/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.VanillaWoodType;
import forestry.modules.features.FeatureBlockGroup;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum WoodAccess implements IWoodAccess
{
    INSTANCE;

    private final Map<WoodBlockKind, WoodMap> woodMaps = new EnumMap<WoodBlockKind, WoodMap>(WoodBlockKind.class);
    private final List<IWoodType> registeredWoodTypes = new ArrayList<IWoodType>();

    private WoodAccess() {
        for (WoodBlockKind woodBlockKind : WoodBlockKind.values()) {
            this.woodMaps.put(woodBlockKind, new WoodMap(woodBlockKind));
        }
        this.registerVanilla();
    }

    public <T extends Block> void registerFeatures(FeatureBlockGroup<? extends T, ? extends IWoodType> featureGroup, WoodBlockKind kind) {
        for (Block block : featureGroup.getBlocks()) {
            this.registerWithoutVariants(block, kind);
        }
    }

    private void registerVanilla() {
        this.register(VanillaWoodType.OAK, WoodBlockKind.LOG, false, Blocks.f_49999_.m_49966_(), () -> Items.f_41837_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.LOG, false, Blocks.f_50000_.m_49966_(), () -> Items.f_41838_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.LOG, false, Blocks.f_50001_.m_49966_(), () -> Items.f_41839_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.LOG, false, Blocks.f_50002_.m_49966_(), () -> Items.f_41840_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.LOG, false, Blocks.f_50003_.m_49966_(), () -> Items.f_41841_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.LOG, false, Blocks.f_50004_.m_49966_(), () -> Items.f_41842_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50010_.m_49966_(), () -> Items.f_41845_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50005_.m_49966_(), () -> Items.f_41846_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50006_.m_49966_(), () -> Items.f_41847_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50007_.m_49966_(), () -> Items.f_41848_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50008_.m_49966_(), () -> Items.f_41849_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50009_.m_49966_(), () -> Items.f_41850_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.WOOD, false, Blocks.f_50011_.m_49966_(), () -> Items.f_41888_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.WOOD, false, Blocks.f_50012_.m_49966_(), () -> Items.f_41889_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.WOOD, false, Blocks.f_50013_.m_49966_(), () -> Items.f_41890_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.WOOD, false, Blocks.f_50014_.m_49966_(), () -> Items.f_41891_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.WOOD, false, Blocks.f_50015_.m_49966_(), () -> Items.f_41892_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.WOOD, false, Blocks.f_50043_.m_49966_(), () -> Items.f_41893_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50044_.m_49966_(), () -> Items.f_41880_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50045_.m_49966_(), () -> Items.f_41881_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50046_.m_49966_(), () -> Items.f_41882_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50047_.m_49966_(), () -> Items.f_41883_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50048_.m_49966_(), () -> Items.f_41884_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50049_.m_49966_(), () -> Items.f_41885_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.PLANKS, false, Blocks.f_50705_.m_49966_(), () -> Items.f_42647_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.PLANKS, false, Blocks.f_50741_.m_49966_(), () -> Items.f_42700_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.PLANKS, false, Blocks.f_50742_.m_49966_(), () -> Items.f_42753_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.PLANKS, false, Blocks.f_50743_.m_49966_(), () -> Items.f_42794_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.PLANKS, false, Blocks.f_50744_.m_49966_(), () -> Items.f_42795_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.PLANKS, false, Blocks.f_50745_.m_49966_(), () -> Items.f_42796_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.SLAB, false, Blocks.f_50398_.m_49966_(), () -> Items.f_41914_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.SLAB, false, Blocks.f_50399_.m_49966_(), () -> Items.f_41915_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.SLAB, false, Blocks.f_50400_.m_49966_(), () -> Items.f_41916_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.SLAB, false, Blocks.f_50401_.m_49966_(), () -> Items.f_41917_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.SLAB, false, Blocks.f_50402_.m_49966_(), () -> Items.f_41918_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.SLAB, false, Blocks.f_50403_.m_49966_(), () -> Items.f_41919_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.FENCE, false, Blocks.f_50132_.m_49966_(), () -> Items.f_42038_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.FENCE, false, Blocks.f_50479_.m_49966_(), () -> Items.f_42039_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.FENCE, false, Blocks.f_50480_.m_49966_(), () -> Items.f_42040_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.FENCE, false, Blocks.f_50481_.m_49966_(), () -> Items.f_42041_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.FENCE, false, Blocks.f_50482_.m_49966_(), () -> Items.f_42042_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.FENCE, false, Blocks.f_50483_.m_49966_(), () -> Items.f_42043_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.FENCE_GATE, false, Blocks.f_50192_.m_49966_(), () -> Items.f_42030_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.FENCE_GATE, false, Blocks.f_50474_.m_49966_(), () -> Items.f_42031_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.FENCE_GATE, false, Blocks.f_50475_.m_49966_(), () -> Items.f_42032_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.FENCE_GATE, false, Blocks.f_50476_.m_49966_(), () -> Items.f_42033_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.FENCE_GATE, false, Blocks.f_50477_.m_49966_(), () -> Items.f_42034_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.FENCE_GATE, false, Blocks.f_50478_.m_49966_(), () -> Items.f_42035_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.STAIRS, false, Blocks.f_50086_.m_49966_(), () -> Items.f_42008_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.STAIRS, false, Blocks.f_50269_.m_49966_(), () -> Items.f_42111_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.STAIRS, false, Blocks.f_50270_.m_49966_(), () -> Items.f_42112_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.STAIRS, false, Blocks.f_50271_.m_49966_(), () -> Items.f_42113_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.STAIRS, false, Blocks.f_50372_.m_49966_(), () -> Items.f_42202_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.STAIRS, false, Blocks.f_50373_.m_49966_(), () -> Items.f_42203_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.DOOR, false, Blocks.f_50154_.m_49966_(), () -> Items.f_42342_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.DOOR, false, Blocks.f_50484_.m_49966_(), () -> Items.f_42343_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.DOOR, false, Blocks.f_50485_.m_49966_(), () -> Items.f_42344_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.DOOR, false, Blocks.f_50486_.m_49966_(), () -> Items.f_42345_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.DOOR, false, Blocks.f_50487_.m_49966_(), () -> Items.f_42346_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.DOOR, false, Blocks.f_50488_.m_49966_(), () -> Items.f_42347_);
    }

    private <T extends Block> void registerWithoutVariants(T woodTyped, WoodBlockKind woodBlockKind) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        BlockState blockState = woodTyped.m_49966_();
        IWoodType woodType = ((IWoodTyped)woodTyped).getWoodType();
        Supplier<Item> itemStack = () -> woodTyped.m_5456_();
        this.register(woodType, woodBlockKind, fireproof, blockState, itemStack);
    }

    @Override
    public void register(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof, BlockState blockState, Supplier<Item> itemStack) {
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        WoodMap woodMap = this.woodMaps.get((Object)woodBlockKind);
        if (!this.registeredWoodTypes.contains(woodType)) {
            this.registeredWoodTypes.add(woodType);
        }
        woodMap.getItem(fireproof).put(woodType, itemStack);
        woodMap.getBlock(fireproof).put(woodType, blockState);
    }

    @Override
    public ItemStack getStack(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        Supplier<Item> itemStack;
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        if ((itemStack = (woodMap = this.woodMaps.get((Object)woodBlockKind)).getItem(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No stack found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return new ItemStack((ItemLike)itemStack.get());
    }

    @Override
    public BlockState getBlock(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        BlockState blockState;
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        if ((blockState = (woodMap = this.woodMaps.get((Object)woodBlockKind)).getBlock(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No block found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return blockState;
    }

    @Override
    public List<IWoodType> getRegisteredWoodTypes() {
        return this.registeredWoodTypes;
    }

    private static class WoodMap {
        private final Map<IWoodType, Supplier<Item>> normalItems = new HashMap<IWoodType, Supplier<Item>>();
        private final Map<IWoodType, Supplier<Item>> fireproofItems = new HashMap<IWoodType, Supplier<Item>>();
        private final Map<IWoodType, BlockState> normalBlocks = new HashMap<IWoodType, BlockState>();
        private final Map<IWoodType, BlockState> fireproofBlocks = new HashMap<IWoodType, BlockState>();
        private final WoodBlockKind woodBlockKind;

        public WoodMap(WoodBlockKind woodBlockKind) {
            this.woodBlockKind = woodBlockKind;
        }

        public String getName() {
            return this.woodBlockKind.name();
        }

        public Map<IWoodType, Supplier<Item>> getItem(boolean fireproof) {
            return fireproof ? this.fireproofItems : this.normalItems;
        }

        public Map<IWoodType, BlockState> getBlock(boolean fireproof) {
            return fireproof ? this.fireproofBlocks : this.normalBlocks;
        }
    }
}

