/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.VanillaWoodType;
import forestry.core.utils.Translator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class WoodHelper {
    public static Component getDisplayName(IWoodTyped wood, IWoodType woodType) {
        MutableComponent displayName;
        WoodBlockKind blockKind = wood.getBlockKind();
        if (woodType instanceof ForestryWoodType) {
            String customUnlocalizedName = "block.forestry." + blockKind + "." + woodType;
            displayName = Translator.canTranslateToLocal(customUnlocalizedName) ? Component.m_237115_((String)customUnlocalizedName) : Component.m_237110_((String)("for." + blockKind + ".grammar"), (Object[])new Object[]{Component.m_237115_((String)("for.trees.woodType." + woodType))});
        } else if (woodType instanceof VanillaWoodType) {
            displayName = TreeManager.woodAccess.getStack(woodType, blockKind, false).m_41786_();
        } else {
            throw new IllegalArgumentException("Unknown wood type: " + woodType);
        }
        if (wood.isFireproof()) {
            displayName = Component.m_237110_((String)"block.forestry.fireproof", (Object[])new Object[]{displayName});
        }
        return displayName;
    }
}

