/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.client.IForestryClientApi;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.core.utils.BlockUtil;
import forestry.modules.features.FeatureBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockDefaultLeavesFruit
extends BlockAbstractLeaves {
    private final ForestryLeafType type;

    public BlockDefaultLeavesFruit(ForestryLeafType type) {
        this.type = type;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult traceResult) {
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        if (mainHand.m_41619_() && offHand.m_41619_()) {
            ITree tree = this.getTree((BlockGetter)level, pos);
            if (tree == null) {
                return InteractionResult.FAIL;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockUtil.sendDestroyEffects(level, pos, state);
            IFruit fruitProvider = tree.getGenome().getActiveValue(TreeChromosomes.FRUIT);
            List<ItemStack> products = tree.produceStacks(level, pos, fruitProvider.getRipeningPeriod());
            level.m_7731_(pos, (BlockState)((BlockState)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(this.type)).defaultState().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)((Integer)state.m_61143_((Property)LeavesBlock.f_54418_))), 2);
            for (ItemStack fruit : products) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)fruit);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void getLeafDrop(List<ItemStack> drops, Level level, @Nullable BlockPos pos, @Nullable GameProfile profile, float saplingModifier, int fortune, LootContext.Builder context) {
        ITree tree = this.type.getIndividual();
        List<ITree> saplings = tree.getSaplings(level, pos, profile, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add(sapling.createStack(TreeLifeStage.SAPLING));
        }
        IGenome genome = tree.getGenome();
        IFruit fruitProvider = genome.getActiveValue(TreeChromosomes.FRUIT);
        if (fruitProvider.isFruitLeaf()) {
            List<ItemStack> produceStacks = tree.produceStacks(level, pos, Integer.MAX_VALUE);
            drops.addAll(produceStacks);
        }
    }

    public ResourceLocation getSpeciesId() {
        return this.type.getSpeciesId();
    }

    public ForestryLeafType getType() {
        return this.type;
    }

    @Override
    protected ITree getTree(BlockGetter world, BlockPos pos) {
        return this.type.getIndividual();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 2) {
            IFruit genome = this.type.getFruit();
            return genome.getDecorativeColor();
        }
        return IForestryClientApi.INSTANCE.getTreeManager().getTint(this.type.getIndividual().getSpecies()).get(level, pos);
    }
}

