/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockForestryPlank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BlockForestryLog
extends RotatedPillarBlock
implements IWoodTyped {
    private final WoodBlockKind kind;
    private final boolean fireproof;
    private final IWoodType woodType;

    public BlockForestryLog(WoodBlockKind kind, boolean fireproof, IWoodType woodType) {
        super(BlockForestryPlank.createWoodProperties(woodType));
        this.kind = kind;
        this.fireproof = fireproof;
        this.woodType = woodType;
    }

    @Override
    public WoodBlockKind getBlockKind() {
        return this.kind;
    }

    @Override
    public final boolean isFireproof() {
        return this.fireproof;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public final int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        if (face == Direction.DOWN) {
            return 20;
        }
        if (face != Direction.UP) {
            return 10;
        }
        return 5;
    }

    public final int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }
}

