/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class BlockForestryPlank
extends Block
implements IWoodTyped {
    private final boolean fireproof;
    private final IWoodType woodType;

    public static BlockBehaviour.Properties createWoodProperties(IWoodType woodType) {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(woodType.getHardness(), woodType.getHardness() * 1.5f).m_60918_(SoundType.f_56736_);
    }

    public BlockForestryPlank(boolean fireproof, IWoodType woodType) {
        super(BlockForestryPlank.createWoodProperties(woodType));
        this.fireproof = fireproof;
        this.woodType = woodType;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Override
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.PLANKS;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }
}

