/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.charcoal.jei;

import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import forestry.api.modules.ForestryModuleIds;
import forestry.arboriculture.charcoal.jei.CharcoalPileWallCategory;
import forestry.arboriculture.features.CharcoalBlocks;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;

@JeiPlugin
public class CharcoalJeiPlugin
implements IModPlugin {
    public static final RecipeType<ICharcoalPileWall> RECIPE_TYPE = RecipeType.create((String)"forestry", (String)"charcoal.pile", ICharcoalPileWall.class);

    public ResourceLocation getPluginUid() {
        return ForestryModuleIds.CHARCOAL;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CharcoalPileWallCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ICharcoalManager charcoalManager = TreeManager.charcoalManager;
        if (charcoalManager == null) {
            return;
        }
        registration.addRecipes(RECIPE_TYPE, charcoalManager.getWalls());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(CharcoalBlocks.WOOD_PILE.stack(), new RecipeType[]{RECIPE_TYPE});
    }
}

