/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.client;

import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.client.IClientModuleHandler;
import forestry.api.client.IForestryClientApi;
import forestry.api.client.arboriculture.ILeafSprite;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.models.ModelDecorativeLeaves;
import forestry.arboriculture.models.ModelDefaultLeaves;
import forestry.arboriculture.models.ModelDefaultLeavesFruit;
import forestry.arboriculture.models.ModelLeaves;
import forestry.arboriculture.models.SaplingModelLoader;
import forestry.core.models.ClientManager;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ArboricultureClientHandler
implements IClientModuleHandler {
    @Override
    public void registerEvents(IEventBus modBus) {
        modBus.addListener(ArboricultureClientHandler::registerModelLoaders);
        modBus.addListener(ArboricultureClientHandler::registerSprites);
        modBus.addListener(ArboricultureClientHandler::onClientSetup);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientManager clientManager = ClientManager.INSTANCE;
            clientManager.registerModel((BakedModel)new ModelLeaves(), ArboricultureBlocks.LEAVES);
            clientManager.registerModel(new ModelDecorativeLeaves<BlockDecorativeLeaves>(BlockDecorativeLeaves.class), ArboricultureBlocks.LEAVES_DECORATIVE);
            clientManager.registerModel((BakedModel)new ModelDefaultLeaves(), ArboricultureBlocks.LEAVES_DEFAULT);
            clientManager.registerModel((BakedModel)new ModelDefaultLeavesFruit(), ArboricultureBlocks.LEAVES_DEFAULT_FRUIT);
            ArboricultureBlocks.LEAVES_DEFAULT.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            ItemBlockRenderTypes.setRenderLayer((Block)ArboricultureBlocks.LEAVES.block(), (RenderType)RenderType.m_110457_());
            ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            ArboricultureBlocks.LEAVES_DECORATIVE.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            ItemBlockRenderTypes.setRenderLayer((Block)ArboricultureBlocks.SAPLING_GE.block(), (RenderType)RenderType.m_110463_());
            ArboricultureBlocks.DOORS.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110466_()));
            ArboricultureBlocks.PODS.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
        });
    }

    private static void registerSprites(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            for (IFruit fruit : TreeChromosomes.FRUIT.values()) {
                fruit.registerSprites(event);
            }
            for (ILeafSprite sprite : IForestryClientApi.INSTANCE.getTreeManager().getAllLeafSprites()) {
                event.addSprite(sprite.get(true, true));
                event.addSprite(sprite.get(true, false));
                event.addSprite(sprite.get(false, true));
                event.addSprite(sprite.get(false, false));
            }
        }
    }

    private static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("sapling_ge", (IGeometryLoader)new SaplingModelLoader());
    }
}

