/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.features;

import com.mojang.datafixers.util.Function3;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IBlockSubtype;
import forestry.api.modules.ForestryModuleIds;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.VanillaWoodType;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeavesFruit;
import forestry.arboriculture.blocks.BlockForestryDoor;
import forestry.arboriculture.blocks.BlockForestryFence;
import forestry.arboriculture.blocks.BlockForestryFenceGate;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.blocks.BlockForestryLog;
import forestry.arboriculture.blocks.BlockForestryPlank;
import forestry.arboriculture.blocks.BlockForestrySlab;
import forestry.arboriculture.blocks.BlockForestryStairs;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.blocks.ForestryPodType;
import forestry.arboriculture.items.ItemBlockDecorativeLeaves;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.arboriculture.items.ItemBlockWoodDoor;
import forestry.arboriculture.items.ItemBlockWoodSlab;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.FeatureGroup;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;

@FeatureProvider
public class ArboricultureBlocks {
    private static final IFeatureRegistry REGISTRY = ModFeatureRegistry.get(ForestryModuleIds.ARBORICULTURE);
    public static final FeatureBlockGroup<BlockForestryLog, VanillaWoodType> LOGS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.LOG, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, VanillaWoodType> WOOD_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.WOOD, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, VanillaWoodType> STRIPPED_LOGS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.STRIPPED_LOG, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, VanillaWoodType> STRIPPED_WOOD_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.STRIPPED_WOOD, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, ForestryWoodType> LOGS = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.LOG, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, ForestryWoodType> LOGS_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.LOG, (boolean)true, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, ForestryWoodType> WOOD = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.WOOD, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, ForestryWoodType> WOOD_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.WOOD, (boolean)true, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryPlank, ForestryWoodType> PLANKS = ArboricultureBlocks.woodGroup(BlockForestryPlank::new, (WoodBlockKind)WoodBlockKind.PLANKS, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryPlank, ForestryWoodType> PLANKS_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryPlank::new, (WoodBlockKind)WoodBlockKind.PLANKS, (boolean)true, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryPlank, VanillaWoodType> PLANKS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryPlank::new, (WoodBlockKind)WoodBlockKind.PLANKS, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestrySlab, ForestryWoodType> SLABS = ArboricultureBlocks.woodGroup((T type) -> new BlockForestrySlab((BlockForestryPlank)((FeatureBlock)PLANKS.get((ForestryWoodType)type)).block()), ItemBlockWoodSlab::new, (WoodBlockKind)WoodBlockKind.SLAB, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestrySlab, ForestryWoodType> SLABS_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestrySlab((BlockForestryPlank)((FeatureBlock)PLANKS_FIREPROOF.get((ForestryWoodType)type)).block()), ItemBlockWoodSlab::new, (WoodBlockKind)WoodBlockKind.SLAB, (boolean)true, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestrySlab, VanillaWoodType> SLABS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestrySlab((BlockForestryPlank)((FeatureBlock)PLANKS_VANILLA_FIREPROOF.get((VanillaWoodType)type)).block()), ItemBlockWoodSlab::new, (WoodBlockKind)WoodBlockKind.SLAB, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFence, ForestryWoodType> FENCES = ArboricultureBlocks.woodGroup(BlockForestryFence::new, (WoodBlockKind)WoodBlockKind.FENCE, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFence, ForestryWoodType> FENCES_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFence::new, (WoodBlockKind)WoodBlockKind.FENCE, (boolean)true, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFence, VanillaWoodType> FENCES_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFence::new, (WoodBlockKind)WoodBlockKind.FENCE, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFenceGate, ForestryWoodType> FENCE_GATES = ArboricultureBlocks.woodGroup(BlockForestryFenceGate::new, (WoodBlockKind)WoodBlockKind.FENCE_GATE, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFenceGate, ForestryWoodType> FENCE_GATES_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFenceGate::new, (WoodBlockKind)WoodBlockKind.FENCE_GATE, (boolean)true, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFenceGate, VanillaWoodType> FENCE_GATES_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFenceGate::new, (WoodBlockKind)WoodBlockKind.FENCE_GATE, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryStairs, ForestryWoodType> STAIRS = ArboricultureBlocks.woodGroup((T type) -> new BlockForestryStairs((BlockForestryPlank)((FeatureBlock)PLANKS.get((ForestryWoodType)type)).block()), (WoodBlockKind)WoodBlockKind.STAIRS, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryStairs, ForestryWoodType> STAIRS_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestryStairs((BlockForestryPlank)((FeatureBlock)PLANKS_FIREPROOF.get((ForestryWoodType)type)).block()), (WoodBlockKind)WoodBlockKind.STAIRS, (boolean)true, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryStairs, VanillaWoodType> STAIRS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestryStairs((BlockForestryPlank)((FeatureBlock)PLANKS_VANILLA_FIREPROOF.get((VanillaWoodType)type)).block()), (WoodBlockKind)WoodBlockKind.STAIRS, (boolean)true, (IWoodType[])VanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryDoor, ForestryWoodType> DOORS = ArboricultureBlocks.woodGroup(BlockForestryDoor::new, ItemBlockWoodDoor::new, (WoodBlockKind)WoodBlockKind.DOOR, (boolean)false, (IWoodType[])ForestryWoodType.VALUES);
    public static final FeatureBlock<BlockSapling, BlockItem> SAPLING_GE = REGISTRY.block(BlockSapling::new, "sapling_ge");
    public static final FeatureBlock<BlockForestryLeaves, ItemBlockLeaves> LEAVES = REGISTRY.block(BlockForestryLeaves::new, ItemBlockLeaves::new, "leaves");
    public static final FeatureBlockGroup<BlockDefaultLeaves, ForestryLeafType> LEAVES_DEFAULT = (FeatureBlockGroup)REGISTRY.blockGroup(BlockDefaultLeaves::new, ForestryLeafType.values()).item(ItemBlockLeaves::new).identifier("default_leaves", FeatureGroup.IdentifierType.AFFIX).create();
    public static final FeatureBlockGroup<BlockDefaultLeavesFruit, ForestryLeafType> LEAVES_DEFAULT_FRUIT = (FeatureBlockGroup)REGISTRY.blockGroup(BlockDefaultLeavesFruit::new, ForestryLeafType.values()).item(ItemBlockLeaves::new).identifier("default_leaves_fruit", FeatureGroup.IdentifierType.AFFIX).create();
    public static final FeatureBlockGroup<BlockDecorativeLeaves, ForestryLeafType> LEAVES_DECORATIVE = (FeatureBlockGroup)REGISTRY.blockGroup(BlockDecorativeLeaves::new, ForestryLeafType.values()).item(ItemBlockDecorativeLeaves::new).identifier("decorative_leaves", FeatureGroup.IdentifierType.AFFIX).create();
    public static final FeatureBlockGroup<BlockFruitPod, ForestryPodType> PODS = (FeatureBlockGroup)REGISTRY.blockGroup(BlockFruitPod::new, ForestryPodType.values()).identifier("pods").create();

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(Function3<WoodBlockKind, Boolean, S, B> constructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.woodGroup((T fireproof1, U type) -> (Block)constructor.apply((Object)kind, fireproof1, type), (T x$0) -> new ItemBlockWood<Block>((Block)x$0), (WoodBlockKind)kind, (boolean)fireproof, types);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(BiFunction<Boolean, S, B> constructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.woodGroup(constructor, (T x$0) -> new ItemBlockWood<Block>((Block)x$0), (WoodBlockKind)kind, (boolean)fireproof, types);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(BiFunction<Boolean, S, B> constructor, Function<B, BlockItem> itemConstructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.registerWood((FeatureBlockGroup)REGISTRY.blockGroup(type -> (Block)constructor.apply(fireproof, type), (IBlockSubtype[])types).item(itemConstructor).identifier((fireproof ? "fireproof_" : "") + kind.m_7912_(), FeatureGroup.IdentifierType.AFFIX).create(), kind);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(Function<S, B> constructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.woodGroup(constructor, (T x$0) -> new ItemBlockWood<Block>((Block)x$0), (WoodBlockKind)kind, (boolean)fireproof, types);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(Function<S, B> constructor, Function<B, BlockItem> itemConstructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.registerWood((FeatureBlockGroup)REGISTRY.blockGroup(constructor, (IBlockSubtype[])types).item(itemConstructor).identifier((fireproof ? "fireproof_" : "") + kind.m_7912_(), FeatureGroup.IdentifierType.AFFIX).create(), kind);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> registerWood(FeatureBlockGroup<B, S> group, WoodBlockKind kind) {
        REGISTRY.addRegistryListener(Registry.f_122904_, event -> WoodAccess.INSTANCE.registerFeatures(group, kind));
        return group;
    }
}

