/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.core.IProduct;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public enum TreeAlyzerPlugin implements IAlyzerPlugin
{
    INSTANCE;

    private final Map<ISpecies<?>, ItemStack> iconStacks = GeneticsUtil.getIconStacks(TreeLifeStage.SAPLING, (ISpeciesType)SpeciesUtil.TREE_TYPE.get());

    @Override
    public void drawAnalyticsPage1(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, (individual, type) -> {
                if (individual instanceof ITree) {
                    ITree tree = (ITree)individual;
                    IGenome genome = tree.getGenome();
                    TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                    textLayout.startPage(transform, 12, 90, 155);
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.inactive"), 155);
                    textLayout.newLine();
                    textLayout.newLine();
                    guiAlyzer.drawSpeciesRow(transform, (Component)Component.m_237115_((String)"for.gui.species"), tree, TreeChromosomes.SPECIES);
                    textLayout.newLine();
                    guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.saplings"), tree, TreeChromosomes.SAPLINGS);
                    textLayout.newLineCompressed();
                    guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.maturity"), tree, TreeChromosomes.MATURATION);
                    textLayout.newLineCompressed();
                    guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.height"), tree, TreeChromosomes.HEIGHT);
                    textLayout.newLineCompressed();
                    int activeGirth = genome.getActiveValue(TreeChromosomes.GIRTH);
                    int inactiveGirth = genome.getInactiveValue(TreeChromosomes.GIRTH);
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.girth"), 12);
                    guiAlyzer.drawLine(transform, String.format("%sx%s", activeGirth, activeGirth), 90, tree, TreeChromosomes.GIRTH, false);
                    guiAlyzer.drawLine(transform, String.format("%sx%s", inactiveGirth, inactiveGirth), 155, tree, TreeChromosomes.GIRTH, true);
                    textLayout.newLineCompressed();
                    guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.yield"), tree, TreeChromosomes.YIELD);
                    textLayout.newLineCompressed();
                    guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.sappiness"), tree, TreeChromosomes.SAPPINESS);
                    textLayout.newLineCompressed();
                    guiAlyzer.drawChromosomeRow(transform, (Component)Component.m_237115_((String)"for.gui.effect"), tree, TreeChromosomes.EFFECT);
                    textLayout.endPage(transform);
                }
            });
        }
    }

    @Override
    public void drawAnalyticsPage2(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, individual -> {
                if (individual instanceof ITree) {
                    ITree tree = (ITree)individual;
                    IGenome genome = tree.getGenome();
                    ITreeSpecies primary = tree.getSpecies();
                    ITreeSpecies secondary = tree.getInactiveSpecies();
                    MutableComponent activeFruit = genome.getActiveName(TreeChromosomes.FRUIT);
                    MutableComponent inactiveFruit = genome.getInactiveName(TreeChromosomes.FRUIT);
                    TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                    textLayout.startPage(transform, 12, 90, 155);
                    int speciesDominance0 = GuiAlyzer.getColorCoding(primary.isDominant());
                    int speciesDominance1 = GuiAlyzer.getColorCoding(secondary.isDominant());
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.active"), 90);
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.inactive"), 155);
                    textLayout.newLine();
                    textLayout.newLine();
                    MutableComponent yes = Component.m_237115_((String)"for.yes");
                    MutableComponent no = Component.m_237115_((String)"for.no");
                    MutableComponent fireproofActive = genome.getActiveValue(TreeChromosomes.FIREPROOF) ? yes : no;
                    MutableComponent fireproofInactive = genome.getInactiveValue(TreeChromosomes.FIREPROOF) ? yes : no;
                    guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.fireproof"), (Component)fireproofActive, (Component)fireproofInactive, tree, TreeChromosomes.FIREPROOF);
                    textLayout.newLine();
                    guiAlyzer.drawRow(transform, (Component)Component.m_237115_((String)"for.gui.fruits"), (Component)activeFruit, (Component)inactiveFruit, tree, TreeChromosomes.FRUIT);
                    textLayout.newLine();
                    textLayout.endPage(transform);
                }
            });
        }
    }

    @Override
    public void drawAnalyticsPage3(PoseStack transform, Screen gui, ItemStack stack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            IIndividualHandlerItem.ifPresent(stack, individual -> {
                if (individual instanceof ITree) {
                    ITree tree = (ITree)individual;
                    TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
                    WidgetManager widgetManager = guiAlyzer.getWidgetManager();
                    textLayout.startPage(transform, 12, 90, 155);
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.beealyzer.produce").m_130946_(":"), 12);
                    textLayout.newLine();
                    int x = 12;
                    for (IProduct product : tree.getProducts()) {
                        widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), product.createStack()));
                        if ((x += 18) <= 148) continue;
                        x = 12;
                        textLayout.newLine();
                    }
                    textLayout.newLine();
                    textLayout.newLine();
                    textLayout.newLine();
                    textLayout.newLine();
                    textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.beealyzer.specialty").m_130946_(":"), 12);
                    textLayout.newLine();
                    x = 12;
                    for (IProduct product : tree.getProducts()) {
                        widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), product.createStack()));
                        if ((x += 18) <= 148) continue;
                        x = 12;
                        textLayout.newLine();
                    }
                    textLayout.endPage(transform);
                }
            });
        }
    }

    @Override
    public Map<ISpecies<?>, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return GuiForestry.HINTS.get((Object)"treealyzer");
    }
}

