/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ForestryTreeSpecies;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.genetics.gatgets.DatabaseMode;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.core.gui.GuiConstants;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.utils.SpeciesUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TreeDatabaseTab
implements IDatabaseTab<ITree> {
    private final DatabaseMode mode;

    TreeDatabaseTab(DatabaseMode mode) {
        this.mode = mode;
    }

    @Override
    public DatabaseMode getMode() {
        return this.mode;
    }

    @Override
    public void createElements(DatabaseElement container, ITree tree, ILifeStage stage, ItemStack stack) {
        AllelePair<ITreeSpecies> speciesPair = tree.getGenome().getAllelePair(TreeChromosomes.SPECIES);
        ITreeSpecies species = (ITreeSpecies)(this.mode == DatabaseMode.ACTIVE ? (IValueAllele)((Object)speciesPair.active()) : (IValueAllele)((Object)speciesPair.inactive())).value();
        Style speciesStyle = GuiElementFactory.INSTANCE.getStateStyle(species.isDominant());
        container.translated("for.gui.database.tab." + (this.mode == DatabaseMode.ACTIVE ? "active" : "inactive") + "_species.name", new Object[0]).setStyle(GuiElementFactory.INSTANCE.databaseTitle).setAlign(Alignment.TOP_CENTER);
        container.addLine((Component)Component.m_237115_((String)"for.gui.species"), TreeChromosomes.SPECIES);
        container.addLine((Component)Component.m_237115_((String)"for.gui.saplings"), TreeChromosomes.SAPLINGS);
        container.addLine((Component)Component.m_237115_((String)"for.gui.maturity"), TreeChromosomes.MATURATION);
        container.addLine((Component)Component.m_237115_((String)"for.gui.height"), TreeChromosomes.HEIGHT);
        container.addLine((Component)Component.m_237115_((String)"for.gui.girth"), (girth, active) -> Component.m_237113_((String)String.format("%sx%s", girth.value(), girth.value())), TreeChromosomes.GIRTH);
        container.addLine((Component)Component.m_237115_((String)"for.gui.yield"), TreeChromosomes.YIELD);
        container.addLine((Component)Component.m_237115_((String)"for.gui.sappiness"), TreeChromosomes.SAPPINESS);
        container.addLine((Component)Component.m_237115_((String)"for.gui.effect"), TreeChromosomes.EFFECT);
        IValueAllele fruit = this.mode == DatabaseMode.ACTIVE ? (IValueAllele)((Object)tree.getGenome().getActiveAllele(TreeChromosomes.FRUIT)) : (IValueAllele)((Object)tree.getGenome().getInactiveAllele(TreeChromosomes.FRUIT));
        Style textStyle = GuiElementFactory.INSTANCE.getStateStyle(((IValueAllele)((Object)tree.getGenome().getActiveAllele(TreeChromosomes.FRUIT))).dominant());
        container.translated("for.gui.fruits", new Object[0]).setStyle(GuiConstants.UNDERLINED_STYLE).setAlign(Alignment.TOP_CENTER);
        container.label((Component)TreeChromosomes.FRUIT.getDisplayName(fruit)).setStyle(textStyle).setAlign(Alignment.TOP_CENTER);
    }

    @Override
    public ItemStack getIconStack() {
        return SpeciesUtil.getTreeSpecies(ForestryTreeSpecies.CHERRY).createStack(this.mode == DatabaseMode.ACTIVE ? TreeLifeStage.SAPLING : TreeLifeStage.POLLEN);
    }
}

