/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.genetics.ITree;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.tiles.TileUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class TreeGrowthHelper {
    @Nullable
    public static BlockPos getGrowthPos(LevelAccessor world, IGenome genome, BlockPos pos, int expectedGirth, int expectedHeight) {
        BlockPos growthPos = TreeGrowthHelper.hasSufficientSaplingsAroundSapling(genome, world, pos, expectedGirth);
        if (growthPos == null) {
            return null;
        }
        if (!TreeGrowthHelper.hasRoom(world, growthPos, expectedGirth, expectedHeight)) {
            return null;
        }
        return growthPos;
    }

    private static boolean hasRoom(LevelAccessor world, BlockPos pos, int expectedGirth, int expectedHeight) {
        Vec3i area = new Vec3i(expectedGirth, expectedHeight + 1, expectedGirth);
        return TreeGrowthHelper.checkArea(world, pos.m_7494_(), area);
    }

    private static boolean checkArea(LevelAccessor world, BlockPos start, Vec3i area) {
        for (int x = 0; x < area.m_123341_(); ++x) {
            for (int y = 0; y < area.m_123342_(); ++y) {
                for (int z = 0; z < area.m_123343_(); ++z) {
                    BlockPos pos = start.m_7918_(x, y, z);
                    BlockState blockState = world.m_8055_(pos);
                    if (blockState.m_60767_().m_76336_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static BlockPos hasSufficientSaplingsAroundSapling(IGenome genome, LevelAccessor world, BlockPos saplingPos, int expectedGirth) {
        int checkSize = expectedGirth * 2 - 1;
        int offset = expectedGirth - 1;
        HashMap<BlockPos, Boolean> knownSaplings = new HashMap<BlockPos, Boolean>(checkSize * checkSize);
        for (int x = -offset; x <= 0; ++x) {
            for (int z = -offset; z <= 0; ++z) {
                BlockPos startPos = saplingPos.m_7918_(x, 0, z);
                if (!TreeGrowthHelper.checkForSaplings(genome, world, startPos, expectedGirth, knownSaplings)) continue;
                return startPos;
            }
        }
        return null;
    }

    private static boolean checkForSaplings(IGenome genome, LevelAccessor world, BlockPos startPos, int girth, Map<BlockPos, Boolean> knownSaplings) {
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                BlockPos checkPos = startPos.m_7918_(x, 0, z);
                Boolean knownSapling = knownSaplings.computeIfAbsent(checkPos, k -> TreeGrowthHelper.isSapling(genome, world, checkPos));
                if (knownSapling.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isSapling(IGenome genome, LevelAccessor world, BlockPos pos) {
        if (!world.m_46805_(pos)) {
            return false;
        }
        if (world.m_46859_(pos)) {
            return false;
        }
        TileSapling sapling = TileUtil.getTile((BlockGetter)world, pos, TileSapling.class);
        if (sapling == null) {
            return false;
        }
        ITree tree = sapling.getTree();
        return tree != null && tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES) == genome.getActiveAllele(TreeChromosomes.SPECIES);
    }
}

