/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.core.ItemGroups;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.genetics.ItemGE;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.core.utils.TreeUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable,
IColoredItem {
    public ItemGermlingGE(TreeLifeStage type) {
        super(new Item.Properties().m_41491_(ItemGroups.tabArboriculture), type);
    }

    protected ITreeSpecies getSpecies(ItemStack stack) {
        return (ITreeSpecies)IIndividualHandlerItem.getSpecies(stack, (ISpeciesType)SpeciesUtil.TREE_TYPE.get());
    }

    @Override
    protected ISpeciesType<?, ?> getType() {
        return (ISpeciesType)SpeciesUtil.TREE_TYPE.get();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_220152_(tab)) {
            ItemGermlingGE.addCreativeItems(this.stage, subItems, true, (ISpeciesType)SpeciesUtil.TREE_TYPE.get());
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack itemstack, int renderPass) {
        return this.getSpecies(itemstack).getGermlingColor(this.stage, renderPass);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        IIndividual tree;
        BlockHitResult traceResult = ItemGermlingGE.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        ItemStack stack = playerIn.m_21120_(handIn);
        if (traceResult.m_6662_() == HitResult.Type.BLOCK && (tree = IIndividualHandlerItem.getIndividual(stack)) != null) {
            BlockPos pos = traceResult.m_82425_();
            if (this.stage == TreeLifeStage.SAPLING) {
                BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(playerIn, handIn, traceResult));
                return ItemGermlingGE.onItemRightClickSapling(stack, worldIn, playerIn, pos, (ITree)tree, context);
            }
            if (this.stage == TreeLifeStage.POLLEN) {
                return ItemGermlingGE.onItemRightClickPollen(stack, worldIn, playerIn, pos, (ITree)tree);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private static InteractionResultHolder<ItemStack> onItemRightClickPollen(ItemStack stack, Level level, Player player, BlockPos pos, ITree pollen) {
        if (!TreeUtil.canMate(TreeUtil.getTreeSafe((LevelAccessor)level, pos), pollen)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        TileLeaves leaves = TreeUtil.getOrCreateLeaves((LevelAccessor)level, pos, true);
        if (leaves == null || !TreeUtil.canMate(leaves.getTree(), pollen)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!level.f_46443_) {
            leaves.setMate(pollen);
            BlockUtil.sendDestroyEffects(level, pos, level.m_8055_(pos));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private static InteractionResultHolder<ItemStack> onItemRightClickSapling(ItemStack stack, Level worldIn, Player player, BlockPos pos, ITree tree, BlockPlaceContext context) {
        BlockState hitBlock = worldIn.m_8055_(pos);
        if (!hitBlock.m_60629_(context)) {
            if (!worldIn.m_46859_(pos.m_7494_())) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            pos = pos.m_7494_();
        }
        if (tree.canStay((BlockGetter)worldIn, pos) && ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).plantSapling(worldIn, tree, player.m_36316_(), pos)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public float getFermentationModifier(ItemStack stack) {
        IIndividual tree = IIndividualHandlerItem.getIndividual(stack);
        if (tree == null) {
            return 1.0f;
        }
        return tree.getGenome().getActiveValue(TreeChromosomes.SAPPINESS) * 10.0f;
    }

    @Override
    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return 100;
    }
}

