/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.mojang.datafixers.util.Pair;
import forestry.api.arboriculture.ForestryTreeSpecies;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.client.IForestryClientApi;
import forestry.api.client.arboriculture.ITreeClientManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.utils.SpeciesUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class ModelSapling
implements IUnbakedGeometry<ModelSapling> {
    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        IdentityHashMap<ITreeSpecies, BakedModel> itemModels = new IdentityHashMap<ITreeSpecies, BakedModel>();
        IdentityHashMap<ITreeSpecies, BakedModel> blockModels = new IdentityHashMap<ITreeSpecies, BakedModel>();
        ITreeClientManager treeManager = IForestryClientApi.INSTANCE.getTreeManager();
        for (ITreeSpecies species : SpeciesUtil.getAllTreeSpecies()) {
            BakedModel itemModel;
            Pair<ResourceLocation, ResourceLocation> pair = treeManager.getSaplingModels(species);
            ResourceLocation blockModelLocation = (ResourceLocation)pair.getFirst();
            ResourceLocation itemModelLocation = (ResourceLocation)pair.getSecond();
            BakedModel blockModel = bakery.bake(blockModelLocation, (ModelState)BlockModelRotation.X0_Y0, spriteGetter);
            if (blockModel != null) {
                blockModels.put(species, blockModel);
            }
            if ((itemModel = bakery.bake(itemModelLocation, (ModelState)BlockModelRotation.X0_Y0, spriteGetter)) == null) continue;
            itemModels.put(species, itemModel);
        }
        return new Baked(itemModels, blockModels);
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ITreeClientManager manager = IForestryClientApi.INSTANCE.getTreeManager();
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        for (Pair<ResourceLocation, ResourceLocation> pair : manager.getAllSaplingModels()) {
            locations.add((ResourceLocation)pair.getFirst());
            locations.add((ResourceLocation)pair.getSecond());
        }
        HashSet<Material> materials = new HashSet<Material>();
        for (ResourceLocation location : locations) {
            materials.addAll(modelGetter.apply(location).m_5500_(modelGetter, missingTextureErrors));
        }
        return materials;
    }

    public static class Baked
    implements BakedModel {
        private final IdentityHashMap<ITreeSpecies, BakedModel> itemModels;
        private final IdentityHashMap<ITreeSpecies, BakedModel> blockModels;
        private final BakedModel defaultBlock;
        private final BakedModel defaultItem;
        @Nullable
        private ItemOverrides overrideList;

        public Baked(IdentityHashMap<ITreeSpecies, BakedModel> itemModels, IdentityHashMap<ITreeSpecies, BakedModel> blockModels) {
            this.itemModels = itemModels;
            this.blockModels = blockModels;
            ITreeSpeciesType speciesType = (ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get();
            ITreeSpecies oakSpecies = (ITreeSpecies)speciesType.getSpecies(ForestryTreeSpecies.OAK);
            this.defaultBlock = Objects.requireNonNull(blockModels.get(oakSpecies));
            this.defaultItem = Objects.requireNonNull(itemModels.get(oakSpecies));
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            ITreeSpecies species = (ITreeSpecies)extraData.get(TileSapling.TREE_SPECIES);
            if (species == null) {
                species = SpeciesUtil.getTreeSpecies(ForestryTreeSpecies.OAK);
            }
            return this.blockModels.get(species).m_213637_(state, side, rand);
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            return this.getQuads(state, side, rand, ModelData.EMPTY, null);
        }

        public boolean m_7541_() {
            return this.defaultBlock.m_7541_();
        }

        public boolean m_7539_() {
            return this.defaultItem.m_7539_();
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.defaultBlock.m_6160_();
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            ITreeSpecies species = (ITreeSpecies)data.get(TileSapling.TREE_SPECIES);
            return this.blockModels.getOrDefault(species, this.defaultBlock).m_6160_();
        }

        public ItemOverrides m_7343_() {
            if (this.overrideList == null) {
                this.overrideList = new OverrideList();
            }
            return this.overrideList;
        }

        public class OverrideList
        extends ItemOverrides {
            @Nullable
            public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int p_173469_) {
                IIndividual individual = IIndividualHandlerItem.getIndividual(stack);
                if (individual == null) {
                    return model;
                }
                return Baked.this.itemModels.getOrDefault(individual.getSpecies(), model);
            }
        }
    }
}

