/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.network;

import forestry.api.modules.IForestryPacketClient;
import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;

public record PacketRipeningUpdate(BlockPos pos, int value) implements IForestryPacketClient
{
    public PacketRipeningUpdate(TileLeaves leaves) {
        this(leaves.m_58899_(), leaves.getFruitColour());
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.RIPENING_UPDATE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.value);
    }

    public static PacketRipeningUpdate decode(FriendlyByteBuf buffer) {
        return new PacketRipeningUpdate(buffer.m_130135_(), buffer.m_130242_());
    }

    public static void handle(PacketRipeningUpdate msg, Player player) {
        TileUtil.actOnTile((LevelReader)player.f_19853_, msg.pos, IRipeningPacketReceiver.class, tile -> tile.fromRipeningPacket(msg.value));
    }
}

