/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.villagers;

import com.google.common.collect.ImmutableSet;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.ILifeStage;
import forestry.api.modules.ForestryModuleIds;
import forestry.apiculture.blocks.NaturalistChestBlockType;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.core.blocks.BlockTesr;
import forestry.core.features.CoreBlocks;
import forestry.core.registration.VillagerTrade;
import forestry.core.utils.SpeciesUtil;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@FeatureProvider
public class ArboricultureVillagers {
    private static final IFeatureRegistry REGISTRY = ModFeatureRegistry.get(ForestryModuleIds.ARBORICULTURE);
    private static final DeferredRegister<PoiType> POINTS_OF_INTEREST = REGISTRY.getRegistry(Registry.f_122810_);
    private static final DeferredRegister<VillagerProfession> PROFESSIONS = REGISTRY.getRegistry(Registry.f_122809_);
    public static final RegistryObject<PoiType> POI_TREE_CHEST = POINTS_OF_INTEREST.register("tree_chest", () -> new PoiType(Set.copyOf(((BlockTesr)((Object)((Object)((FeatureBlock)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.ARBORIST_CHEST)).block()))).m_49965_().m_61056_()), 1, 1));
    public static final RegistryObject<VillagerProfession> ARBORIST = PROFESSIONS.register("arborist", () -> {
        ResourceKey key = Objects.requireNonNull(POI_TREE_CHEST.getKey());
        Predicate<Holder> jobSitePredicate = poi -> poi.m_203565_(key);
        return new VillagerProfession("arborist", jobSitePredicate, jobSitePredicate, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12568_);
    });

    public static void villagerTrades(VillagerTradesEvent event) {
        if (event.getType() == ARBORIST.get()) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).add(new GivePlanksForEmeralds(new VillagerTrade.PriceInterval(1, 4), new VillagerTrade.PriceInterval(10, 32), 8, 2, 0.0f));
            ((List)trades.get(1)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 3), TreeLifeStage.SAPLING, 4, 8, 2, 0.0f));
            ((List)trades.get(2)).add(new GivePlanksForEmeralds(new VillagerTrade.PriceInterval(1, 4), new VillagerTrade.PriceInterval(10, 32), 8, 6, 0.0f));
            ((List)trades.get(2)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(2, 3), new VillagerTrade.PriceInterval(1, 1), TreeLifeStage.POLLEN, 6, 8, 6, 0.0f));
            ((List)trades.get(2)).add(new VillagerTrade.GiveItemForEmeralds(ArboricultureItems.GRAFTER_PROVEN.item(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 4), 8, 6));
            ((List)trades.get(3)).add(new GiveLogsForEmeralds(new VillagerTrade.PriceInterval(2, 5), new VillagerTrade.PriceInterval(6, 18), 8, 2, 0.0f));
            ((List)trades.get(3)).add(new GiveLogsForEmeralds(new VillagerTrade.PriceInterval(2, 5), new VillagerTrade.PriceInterval(6, 18), 8, 2, 0.0f));
            ((List)trades.get(4)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(5, 20), new VillagerTrade.PriceInterval(1, 1), TreeLifeStage.POLLEN, 10, 8, 15, 0.0f));
            ((List)trades.get(4)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(5, 20), new VillagerTrade.PriceInterval(1, 1), TreeLifeStage.SAPLING, 10, 8, 15, 0.0f));
        }
    }

    private record GivePlanksForEmeralds(VillagerTrade.PriceInterval emeraldsPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, int maxUses, int xp, float priceMult) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(@NotNull Entity trader, @NotNull RandomSource rand) {
            ForestryWoodType woodType = ForestryWoodType.getRandom(rand);
            ItemStack sellStack = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.PLANKS, false);
            sellStack.m_41764_(this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldsPriceInfo.getPrice(rand)), sellStack, this.maxUses, this.xp, this.priceMult);
        }
    }

    private record GivePollenForEmeralds(VillagerTrade.PriceInterval buyingPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, ILifeStage stage, int maxComplexity, int maxUses, int xp, float priceMult) implements VillagerTrades.ItemListing
    {
        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            List<ITreeSpecies> registeredSpecies = SpeciesUtil.getAllTreeSpecies();
            ArrayList<ITreeSpecies> potentialSpecies = new ArrayList<ITreeSpecies>();
            for (ITreeSpecies species : registeredSpecies) {
                if (species.getComplexity() > this.maxComplexity) continue;
                potentialSpecies.add(species);
            }
            if (potentialSpecies.isEmpty()) {
                return null;
            }
            ITreeSpecies chosenSpecies = (ITreeSpecies)potentialSpecies.get(rand.m_188503_(potentialSpecies.size()));
            ItemStack sellStack = chosenSpecies.createStack(this.stage);
            sellStack.m_41764_(this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.buyingPriceInfo.getPrice(rand)), sellStack, this.maxUses, this.xp, this.priceMult);
        }
    }

    private record GiveLogsForEmeralds(VillagerTrade.PriceInterval emeraldsPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, int maxUses, int xp, float priceMult) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(@NotNull Entity trader, @NotNull RandomSource rand) {
            ForestryWoodType woodType = ForestryWoodType.getRandom(rand);
            ItemStack sellStack = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.LOG, false);
            sellStack.m_41764_(this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldsPriceInfo.getPrice(rand)), sellStack, this.maxUses, this.xp, this.priceMult);
        }
    }
}

