/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ITreeGenData;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.tiles.TileUtil;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DefaultTreeGenerator
implements ITreeGenerator {
    private final Function<ITreeGenData, Feature<NoneFeatureConfiguration>> factory;
    private final IWoodType woodType;

    public DefaultTreeGenerator(Function<ITreeGenData, Feature<NoneFeatureConfiguration>> factory, IWoodType woodType) {
        this.factory = factory;
        this.woodType = (IWoodType)Preconditions.checkNotNull((Object)woodType);
    }

    @Override
    public Feature<NoneFeatureConfiguration> getTreeFeature(ITreeGenData tree) {
        return this.factory.apply(tree);
    }

    @Override
    public boolean setLogBlock(IGenome genome, LevelAccessor level, BlockPos pos, Direction facing) {
        boolean fireproof = genome.getActiveValue(TreeChromosomes.FIREPROOF);
        BlockState logBlock = TreeManager.woodAccess.getBlock(this.woodType, WoodBlockKind.LOG, fireproof);
        Direction.Axis axis = facing.m_122434_();
        return level.m_7731_(pos, (BlockState)logBlock.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 19);
    }

    @Override
    public boolean setLeaves(IGenome genome, LevelAccessor level, BlockPos pos, RandomSource rand) {
        if (genome.isDefaultGenome()) {
            return this.woodType.setDefaultLeaves(level, pos, genome, rand, null);
        }
        BlockState leaves = ArboricultureBlocks.LEAVES.defaultState();
        boolean placed = level.m_7731_(pos, LeavesBlock.m_54435_((BlockState)leaves, (LevelAccessor)level, (BlockPos)pos), 19);
        if (!placed) {
            return false;
        }
        TileLeaves tileLeaves = TileUtil.getTile((BlockGetter)level, pos, TileLeaves.class);
        if (tileLeaves == null) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 19);
            return false;
        }
        Tree tree = new Tree(genome);
        tileLeaves.setTree(tree);
        tileLeaves.setFruit(tree, false);
        return true;
    }
}

