/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forestry.api.arboriculture.ITreeGenData;
import forestry.api.genetics.IGenome;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.utils.VecUtil;
import forestry.core.worldgen.FeatureBase;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public abstract class FeatureArboriculture
extends FeatureBase {
    protected static final int minPodHeight = 3;
    protected final ITreeGenData tree;

    protected FeatureArboriculture(ITreeGenData tree) {
        this.tree = tree;
    }

    @Override
    public IGenome getDefaultGenome() {
        return this.tree.getDefaultGenome();
    }

    @Override
    public boolean place(IGenome genome, LevelAccessor world, RandomSource rand, BlockPos pos, boolean forced) {
        TreeBlockTypeLeaf leaf = new TreeBlockTypeLeaf(this.tree, genome);
        TreeBlockTypeLog wood = new TreeBlockTypeLog(this.tree, genome);
        this.preGenerate(genome, world, rand, pos);
        BlockPos genPos = forced ? pos : this.getValidGrowthPos(world, pos);
        if (genPos != null) {
            this.clearSaplings(world, genPos);
            ArrayList<BlockPos> branchEnds = new ArrayList<BlockPos>(this.generateTrunk(world, rand, wood, genPos));
            branchEnds.sort(VecUtil.TOP_DOWN_COMPARATOR);
            TreeContour.Impl contour = new TreeContour.Impl(branchEnds);
            this.generateLeaves(world, rand, leaf, contour, genPos);
            this.generateExtras(world, rand, genPos);
            this.updateLeaves(world, contour);
            DiscreteVoxelShape voxelshapepart = this.updateLeaves(world, contour);
            StructureTemplate.m_74510_((LevelAccessor)world, (int)3, (DiscreteVoxelShape)voxelshapepart, (int)contour.boundingBox.m_162395_(), (int)contour.boundingBox.m_162396_(), (int)contour.boundingBox.m_162398_());
            return true;
        }
        return false;
    }

    public void preGenerate(IGenome genome, LevelAccessor world, RandomSource rand, BlockPos startPos) {
    }

    private DiscreteVoxelShape updateLeaves(LevelAccessor world, TreeContour.Impl contour) {
        BoundingBox boundingBox = contour.boundingBox;
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape voxelshapepart = new BitSetDiscreteVoxelShape(boundingBox.m_71056_(), boundingBox.m_71057_(), boundingBox.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos1 : Lists.newArrayList(contour.leavePositions)) {
            if (boundingBox.m_71051_((Vec3i)blockpos1)) {
                voxelshapepart.m_142703_(blockpos1.m_123341_() - boundingBox.m_162395_(), blockpos1.m_123342_() - boundingBox.m_162396_(), blockpos1.m_123343_() - boundingBox.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.m_122159_((Vec3i)blockpos1, direction);
                if (contour.leavePositions.contains(blockpos$mutable) || !(blockstate = world.m_8055_((BlockPos)blockpos$mutable)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.m_7949_());
                if (!boundingBox.m_71051_((Vec3i)blockpos$mutable)) continue;
                voxelshapepart.m_142703_(blockpos$mutable.m_123341_() - boundingBox.m_162395_(), blockpos$mutable.m_123342_() - boundingBox.m_162396_(), blockpos$mutable.m_123343_() - boundingBox.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (boundingBox.m_71051_((Vec3i)blockpos2)) {
                    voxelshapepart.m_142703_(blockpos2.m_123341_() - boundingBox.m_162395_(), blockpos2.m_123342_() - boundingBox.m_162396_(), blockpos2.m_123343_() - boundingBox.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = world.m_8055_((BlockPos)blockpos$mutable)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    if (boundingBox.m_71051_((Vec3i)blockpos$mutable)) {
                        voxelshapepart.m_142703_(blockpos$mutable.m_123341_() - boundingBox.m_162395_(), blockpos$mutable.m_123342_() - boundingBox.m_162396_(), blockpos$mutable.m_123343_() - boundingBox.m_162398_());
                    }
                    set1.add(blockpos$mutable.m_7949_());
                }
            }
        }
        return voxelshapepart;
    }

    protected abstract Set<BlockPos> generateTrunk(LevelAccessor var1, RandomSource var2, TreeBlockTypeLog var3, BlockPos var4);

    protected abstract void generateLeaves(LevelAccessor var1, RandomSource var2, TreeBlockTypeLeaf var3, TreeContour var4, BlockPos var5);

    protected abstract void generateExtras(LevelAccessor var1, RandomSource var2, BlockPos var3);

    @Nullable
    public abstract BlockPos getValidGrowthPos(LevelAccessor var1, BlockPos var2);

    public void clearSaplings(LevelAccessor world, BlockPos genPos) {
        int treeGirth = this.tree.getGirth(this.tree.getDefaultGenome());
        for (int x = 0; x < treeGirth; ++x) {
            for (int z = 0; z < treeGirth; ++z) {
                BlockPos saplingPos = genPos.m_7918_(x, 0, z);
                if (!(world.m_8055_(saplingPos).m_60734_() instanceof BlockSapling)) continue;
                world.m_7731_(saplingPos, Blocks.f_50016_.m_49966_(), 18);
            }
        }
    }

    public boolean hasPods() {
        return this.tree.allowsFruitBlocks(this.tree.getDefaultGenome());
    }
}

