/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureCocobolo
extends FeatureTree {
    public FeatureCocobolo(ITreeGenData tree) {
        super(tree, 8, 8);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor world, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        return FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
    }

    @Override
    protected void generateLeaves(LevelAccessor world, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height;
        for (BlockPos treeTop : contour.getBranchEnds()) {
            FeatureHelper.addBlock(world, treeTop.m_7494_(), leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        int n = --leafSpawn;
        --leafSpawn;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, n, 0), this.girth, 1 + this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        if (this.height > 10) {
            FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 2 + this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        --leafSpawn;
        while (leafSpawn > 4) {
            int offset = 1;
            if (rand.m_188499_()) {
                offset = -1;
            }
            float radius = leafSpawn % 2 == 0 ? (float)(2 + this.girth) : (float)this.girth;
            FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(offset, leafSpawn, offset), this.girth, radius, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
            --leafSpawn;
        }
    }
}

