/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class FeatureEbony
extends FeatureTree {
    public FeatureEbony(ITreeGenData tree) {
        super(tree, 10, 4);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor world, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        int trunksGenerated = 0;
        for (int x = 0; x < this.girth; ++x) {
            for (int z = 0; z < this.girth; ++z) {
                if (rand.m_188501_() < 0.6f) {
                    for (int y = 0; y < this.height; ++y) {
                        FeatureHelper.addBlock(world, startPos.m_7918_(x, y, z), wood, FeatureHelper.EnumReplaceMode.ALL);
                        if (y > this.height / 2 && rand.m_188501_() < 0.1f * (float)(10 / this.height)) break;
                    }
                    ++trunksGenerated;
                    continue;
                }
                for (int i = 0; i < 1; ++i) {
                    world.m_7731_(startPos.m_7918_(x, i, z), Blocks.f_50016_.m_49966_(), 18);
                }
            }
        }
        if (trunksGenerated <= 0) {
            FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, 1, 0, 0.6f, null, 0.0f);
        }
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(LevelAccessor world, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        for (int times = 0; times < 2 * this.height; ++times) {
            int h = 2 * this.girth + rand.m_188503_(this.height - this.girth);
            if (rand.m_188499_() && h < this.height / 2) {
                h = this.height / 2 + rand.m_188503_(this.height / 2);
            }
            int x_off = rand.m_188503_(this.girth);
            int y_off = rand.m_188503_(this.girth);
            BlockPos center = startPos.m_7918_(x_off, h, y_off);
            int radius = 1 + rand.m_188503_(this.girth);
            FeatureHelper.generateSphere(world, center, radius, leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
    }
}

