/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureGreenheart
extends FeatureTree {
    public FeatureGreenheart(ITreeGenData tree) {
        super(tree, 10, 8);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor world, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.4f, null, 0.0f);
        FeatureHelper.generateSupportStems(wood, world, rand, startPos, this.height, this.girth, 0.5f, 0.2f);
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(LevelAccessor world, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        while (leafSpawn > this.height - 4) {
            FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        if (this.height > 10) {
            for (int times = 0; times < this.height / 4; ++times) {
                int h = 10 + rand.m_188503_(this.height - 10);
                if (rand.m_188499_() && h < this.height / 2) {
                    h = this.height / 2 + rand.m_188503_(this.height / 2);
                }
                int x_off = -1 + rand.m_188503_(3);
                int y_off = -1 + rand.m_188503_(3);
                FeatureHelper.generateSphere(world, startPos.m_7918_(x_off, h, y_off), 1 + rand.m_188503_(1), leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
            }
        }
    }
}

