/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureMahoe
extends FeatureTree {
    public FeatureMahoe(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor world, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>(FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f));
        for (int yBranch = 2; yBranch < this.height - 1; ++yBranch) {
            branchCoords.addAll(FeatureHelper.generateBranches(world, rand, wood, startPos.m_7918_(0, yBranch, 0), this.girth, 0.15f, 0.25f, Math.round((float)(this.height - yBranch) * 0.75f), 1, 0.25f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(LevelAccessor world, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(world, leaf, branchEnd, 2 + this.girth, 2, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        FeatureHelper.generateSphereFromTreeStartPos(world, startPos.m_7918_(0, yCenter, 0), this.girth, 3 + rand.m_188503_(this.girth), leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
    }
}

