/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureTeak
extends FeatureTree {
    public FeatureTeak(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor world, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        int branchWidth = this.height / 3;
        return FeatureHelper.generateBranches(world, rand, wood, startPos.m_7918_(0, this.height - 3, 0), this.girth, 0.2f, 0.5f, branchWidth, 1, 1.0f);
    }

    @Override
    protected void generateLeaves(LevelAccessor world, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        float leafMultiplier = (float)this.height / 6.0f;
        if (leafMultiplier > 2.0f) {
            leafMultiplier = 2.0f;
        }
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCircle(world, rand, branchEnd, 2.0f, Math.round(3.0f * leafMultiplier), 2, leaf, 1.0f, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 0.5f * leafMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.9f * leafMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.9f * leafMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        if (rand.m_188499_()) {
            FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.9f * leafMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn, 0), this.girth, 0.5f * leafMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
    }
}

