/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureWalnut
extends FeatureTree {
    public FeatureWalnut(ITreeGenData tree) {
        super(tree, 7, 3);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor world, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        int branchHeight = this.height - 3;
        float branchSize = 2.0f;
        while (branchHeight >= 3) {
            branchEnds.addAll(FeatureHelper.generateBranches(world, rand, wood, startPos.m_7918_(0, branchHeight, 0), this.girth, 0.2f, 0.2f, (int)branchSize, 1, 0.5f));
            --branchHeight;
            branchSize += 0.25f;
        }
        return branchEnds;
    }

    @Override
    protected void generateLeaves(LevelAccessor world, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        float branchSize = 2.0f;
        while (leafSpawn >= 3) {
            int leafRadius = Math.min(4, (int)branchSize);
            for (BlockPos branchEnd : contour.getBranchEnds()) {
                FeatureHelper.generateCircle(world, rand, branchEnd, leafRadius, 2, 2, leaf, 1.0f, FeatureHelper.EnumReplaceMode.SOFT, contour);
            }
            --leafSpawn;
            branchSize += 0.25f;
        }
    }
}

