/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureWenge
extends FeatureTree {
    public FeatureWenge(ITreeGenData tree) {
        super(tree, 6, 2);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor world, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        float branchSize = 3.0f;
        int branchHeight = this.height + 1;
        while (branchHeight > 1) {
            branchEnds.addAll(FeatureHelper.generateBranches(world, rand, wood, startPos.m_7918_(0, branchHeight, 0), this.girth, 0.2f, 0.2f, (int)branchSize, 2, 0.75f));
            --branchHeight;
            branchSize += 0.5f;
        }
        return branchEnds;
    }

    @Override
    protected void generateLeaves(LevelAccessor world, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        while (leafSpawn > 1) {
            FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 3.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
            --leafSpawn;
        }
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCircle(world, rand, branchEnd, 3.0f, 3, 2, leaf, 1.0f, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
    }
}

