/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public interface TreeContour {
    public static final TreeContour EMPTY = new Empty();

    default public void addLeaf(BlockPos pos) {
    }

    default public Collection<BlockPos> getBranchEnds() {
        return Collections.emptyList();
    }

    public static class Empty
    implements TreeContour {
        private Empty() {
        }
    }

    public static class Impl
    implements TreeContour {
        public final Set<BlockPos> leavePositions = new HashSet<BlockPos>();
        public final List<BlockPos> branchEnds;
        @Nullable
        public BoundingBox boundingBox;

        public Impl(List<BlockPos> branchEnds) {
            this.branchEnds = branchEnds;
            this.boundingBox = null;
        }

        @Override
        public void addLeaf(BlockPos pos) {
            this.leavePositions.add(pos.m_7949_());
            if (this.boundingBox == null) {
                this.boundingBox = new BoundingBox(pos);
            } else {
                this.boundingBox.m_162371_(pos);
            }
        }

        public List<BlockPos> getBranchEnds() {
            return this.branchEnds;
        }
    }
}

