/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.IForestryApi;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.climate.IClimateManager;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.arboriculture.TreeConfig;
import forestry.arboriculture.commands.TreeGenHelper;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.IPlantable;

public class TreeDecorator
extends Feature<NoneFeatureConfiguration> {
    private static final IdentityHashMap<ResourceKey<Biome>, List<ITree>> BIOME_CACHE = new IdentityHashMap();

    public TreeDecorator() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    @Nullable
    private static BlockPos getValidPos(WorldGenLevel world, int x, int z, ITree tree) {
        BlockPos topPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(x, 0, z));
        if (topPos.m_123342_() == 0) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos.m_123341_(), topPos.m_123342_(), topPos.m_123343_());
        BlockState blockState = world.m_8055_((BlockPos)pos);
        while (BlockUtil.canReplace(blockState, (LevelAccessor)world, (BlockPos)pos)) {
            pos.m_122173_(Direction.DOWN);
            if (pos.m_123342_() <= 0) {
                return null;
            }
            blockState = world.m_8055_((BlockPos)pos);
        }
        if (tree instanceof IPlantable) {
            IPlantable plantable = (IPlantable)tree;
            if (blockState.m_60734_().canSustainPlant(blockState, (BlockGetter)world, (BlockPos)pos, Direction.UP, plantable)) {
                return pos.m_7494_();
            }
        }
        return null;
    }

    private static synchronized void generateBiomeCache(WorldGenLevel level) {
        if (!BIOME_CACHE.isEmpty()) {
            return;
        }
        List<ITreeSpecies> allSpecies = SpeciesUtil.getAllTreeSpecies();
        IClimateManager manager = IForestryApi.INSTANCE.getClimateManager();
        IdentityHashMap treeInstances = new IdentityHashMap(allSpecies.size());
        level.m_5962_().m_175515_(Registry.f_122885_).m_203611_().forEach(biome -> {
            List trees = BIOME_CACHE.computeIfAbsent((ResourceKey<Biome>)biome.m_205785_(), k -> new ArrayList());
            TemperatureType temperature = manager.getTemperature((Holder<Biome>)biome);
            HumidityType humidity = manager.getHumidity((Holder<Biome>)biome);
            for (ITreeSpecies species : allSpecies) {
                if (!(species.getRarity() > 0.0f) || temperature != species.getTemperature() || humidity != species.getHumidity()) continue;
                trees.add(treeInstances.computeIfAbsent(species, k -> (ITree)species.createIndividual()));
            }
        });
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        float globalRarity = TreeConfig.getSpawnRarity();
        if (globalRarity <= 0.0f) {
            return false;
        }
        if (BIOME_CACHE.isEmpty()) {
            TreeDecorator.generateBiomeCache(level);
        }
        for (int tries = 0; tries < 4; ++tries) {
            int x = pos.m_123341_() + rand.m_188503_(16);
            int z = pos.m_123343_() + rand.m_188503_(16);
            Holder biome = level.m_204166_(pos);
            List trees = BIOME_CACHE.computeIfAbsent((ResourceKey<Biome>)((ResourceKey)biome.m_203543_().get()), k -> List.of());
            for (ITree tree : trees) {
                BlockPos validPos;
                ITreeSpecies species = tree.getSpecies();
                if (!(species.getRarity() * globalRarity >= rand.m_188501_()) || (validPos = TreeDecorator.getValidPos(level, x, z, tree)) == null || !TreeGenHelper.generateTree(species, level, validPos)) continue;
                return true;
            }
        }
        return false;
    }
}

