/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.IForestryApi;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.ApiaristAI;
import forestry.apiculture.features.ApicultureEffects;
import forestry.apiculture.villagers.ApicultureVillagers;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="forestry")
public class EventHandlerCore {
    @SubscribeEvent
    public static void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        EventHandlerCore.syncBreedingTrackers(player);
    }

    @SubscribeEvent
    public static void handlePlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        EventHandlerCore.syncBreedingTrackers(player);
    }

    private static void syncBreedingTrackers(Player player) {
        for (ISpeciesType<?, ?> type : IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypes()) {
            IBreedingTracker breedingTracker = type.getBreedingTracker((LevelAccessor)player.m_20193_(), player.m_36316_());
            breedingTracker.syncToPlayer(player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Villager villager;
        Entity entity = event.getEntity();
        if (entity instanceof Villager && (villager = (Villager)entity).m_7141_().m_35571_().equals(ApicultureVillagers.PROF_BEEKEEPER.get())) {
            villager.f_21345_.m_25352_(6, (Goal)new ApiaristAI(villager, 0.6));
        }
    }

    @SubscribeEvent
    public static void doHakunaDamageReduction(LivingAttackEvent event) {
        if (event.getEntity().m_21023_((MobEffect)ApicultureEffects.HAKUNA_MATATA.get())) {
            event.setCanceled(true);
            if (event.getAmount() > 5.0f) {
                LivingEntity attacker;
                event.getEntity().m_21195_((MobEffect)ApicultureEffects.HAKUNA_MATATA.get());
                event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ApicultureEffects.MATATA.get(), (int)(300.0f * event.getAmount())));
                event.getEntity().m_216990_(SoundEvents.f_12555_);
                Entity entity = event.getSource().m_7639_();
                if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21023_((MobEffect)ApicultureEffects.HAKUNA_MATATA.get())) {
                    attacker.m_21195_((MobEffect)ApicultureEffects.HAKUNA_MATATA.get());
                    attacker.m_7292_(new MobEffectInstance((MobEffect)ApicultureEffects.MATATA.get(), (int)(300.0f * event.getAmount())));
                    attacker.m_216990_(SoundEvents.f_12555_);
                }
            }
        }
    }
}

