/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import forestry.api.circuits.CircuitHolder;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitManager;
import forestry.core.circuits.CircuitBoard;
import forestry.core.features.CoreItems;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class CircuitManager
implements ICircuitManager {
    private final ImmutableMultimap<ICircuitLayout, CircuitHolder> circuitHolders;
    private final ImmutableMap<String, ICircuitLayout> layoutsById;
    private final ImmutableMap<String, ICircuit> circuitsById;

    public CircuitManager(ImmutableMultimap<ICircuitLayout, CircuitHolder> circuitHolders, ImmutableMap<String, ICircuitLayout> layoutsById, ImmutableMap<String, ICircuit> circuitsById) {
        this.circuitHolders = circuitHolders;
        this.layoutsById = layoutsById;
        this.circuitsById = circuitsById;
    }

    @Override
    public List<ICircuitLayout> getLayouts() {
        return this.layoutsById.values().asList();
    }

    @Override
    @Nullable
    public ICircuit getCircuit(ICircuitLayout layout, ItemStack stack) {
        for (CircuitHolder holder : this.circuitHolders.get((Object)layout)) {
            if (!holder.stack().m_41656_(stack)) continue;
            return holder.circuit();
        }
        return null;
    }

    @Override
    @Nullable
    public ICircuit getCircuit(String circuitId) {
        return (ICircuit)this.circuitsById.get((Object)circuitId);
    }

    @Override
    @Nullable
    public ICircuitLayout getLayout(String layoutId) {
        return (ICircuitLayout)this.layoutsById.get((Object)layoutId);
    }

    @Override
    @Nullable
    public ICircuitBoard getCircuitBoard(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null ? null : new CircuitBoard(tag);
    }

    @Override
    public boolean isCircuitBoard(ItemStack stack) {
        return CoreItems.CIRCUITBOARDS.itemEqual(stack);
    }

    @Override
    public Collection<CircuitHolder> getCircuitHolders() {
        return this.circuitHolders.values();
    }
}

