/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.IForestryApi;
import forestry.api.circuits.ForestryCircuitSocketTypes;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.farming.HorizontalDirection;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.gui.GuiForestry;
import forestry.core.inventory.ItemInventorySolderingIron;
import forestry.core.render.ColourProperties;
import java.util.Locale;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class GuiSolderingIron
extends GuiForestry<ContainerSolderingIron> {
    private final ItemInventorySolderingIron itemInventory;

    public GuiSolderingIron(ContainerSolderingIron container, Inventory inv, Component title) {
        super("textures/gui/solder.png", container, inv, title);
        this.itemInventory = (ItemInventorySolderingIron)container.getItemInventory();
        this.f_97726_ = 176;
        this.f_97727_ = 205;
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(transform, partialTicks, mouseX, mouseY);
        ICircuitLayout layout = ((ContainerSolderingIron)this.f_97732_).getLayout();
        Component title = layout.getName();
        this.f_96547_.m_92889_(transform, title, (float)(this.f_97735_ + 8 + this.textLayout.getCenteredOffset(title, 138)), (float)(this.f_97736_ + 16), ColourProperties.INSTANCE.get("gui.screen"));
        for (int i = 0; i < 4; ++i) {
            ItemStack tube = this.itemInventory.m_8020_(i + 2);
            ICircuit circuit = IForestryApi.INSTANCE.getCircuitManager().getCircuit(layout, tube);
            Object description = circuit == null ? Component.m_237113_((String)"(").m_7220_((Component)Component.m_237115_((String)"for.gui.noeffect")).m_130946_(")") : circuit.getDisplayName();
            int row = i * 20;
            this.f_96547_.m_92889_(transform, description, (float)(this.f_97735_ + 32), (float)(this.f_97736_ + 36 + row), ColourProperties.INSTANCE.get("gui.screen"));
            if (!tube.m_41619_() || ForestryCircuitSocketTypes.FARM != layout.getSocketType()) continue;
            Direction farmDirection = HorizontalDirection.VALUES.get(i);
            String farmDirectionString = farmDirection.toString().toLowerCase(Locale.ENGLISH);
            MutableComponent localizedDirection = Component.m_237115_((String)("for.gui.solder." + farmDirectionString));
            this.f_96547_.m_92889_(transform, (Component)localizedDirection, (float)(this.f_97735_ + 17), (float)(this.f_97736_ + 36 + row), ColourProperties.INSTANCE.get("gui.screen"));
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 12, this.f_97736_ + 10, 12, 18, (Component)Component.m_237113_((String)"<"), b -> ContainerSolderingIron.regressSelection(0)));
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 130, this.f_97736_ + 10, 12, 18, (Component)Component.m_237113_((String)">"), b -> ContainerSolderingIron.advanceSelection(0)));
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger("soldering.iron");
    }
}

