/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import forestry.api.client.IClientModuleHandler;
import forestry.api.client.IForestryClientApi;
import forestry.api.core.ISpectacleBlock;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiimpl.plugin.PluginManager;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.core.circuits.GuiSolderingIron;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.features.CoreMenuTypes;
import forestry.core.features.CoreTiles;
import forestry.core.features.FluidsItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.GuiAnalyzer;
import forestry.core.gui.GuiEscritoire;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.models.ClientManager;
import forestry.core.models.FluidContainerModel;
import forestry.core.models.ModelBlockCached;
import forestry.core.render.ColourProperties;
import forestry.core.render.ForestryBewlr;
import forestry.core.render.ForestryModelLayers;
import forestry.core.render.ForestryTextureManager;
import forestry.core.render.RenderAnalyzer;
import forestry.core.render.RenderEngine;
import forestry.core.render.RenderEscritoire;
import forestry.core.render.RenderMachine;
import forestry.core.render.RenderMill;
import forestry.core.render.RenderNaturalistChest;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.RenderUtil;
import forestry.energy.features.EnergyTiles;
import forestry.factory.features.FactoryTiles;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.mail.features.MailItems;
import forestry.storage.features.BackpackItems;
import forestry.storage.features.CrateItems;
import java.awt.Color;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CoreClientHandler
implements IClientModuleHandler {
    public static BlockEntityWithoutLevelRenderer bewlr;
    public static final RenderType RENDER_TYPE_LINES_XRAY;

    @Override
    public void registerEvents(IEventBus modBus) {
        modBus.addListener(CoreClientHandler::onClientSetup);
        modBus.addListener(CoreClientHandler::registerModelLoaders);
        modBus.addListener(CoreClientHandler::bakeModels);
        modBus.addListener(CoreClientHandler::setupLayers);
        modBus.addListener(CoreClientHandler::clientSetupRenderers);
        modBus.addListener(CoreClientHandler::handleTextureRemap);
        modBus.addListener(CoreClientHandler::registerReloadListeners);
        modBus.addListener(CoreClientHandler::registerBlockColors);
        modBus.addListener(CoreClientHandler::registerItemColors);
        MinecraftForge.EVENT_BUS.addListener(CoreClientHandler::onClientTick);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            CoreBlocks.BASE.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            for (ForestryFluids fluid : ForestryFluids.values()) {
                ItemBlockRenderTypes.setRenderLayer((Fluid)fluid.getFluid(), (RenderType)RenderType.m_110466_());
                ItemBlockRenderTypes.setRenderLayer((Fluid)fluid.getFlowing(), (RenderType)RenderType.m_110466_());
            }
            MenuScreens.m_96206_(CoreMenuTypes.ALYZER.menuType(), GuiAlyzer::new);
            MenuScreens.m_96206_(CoreMenuTypes.ANALYZER.menuType(), GuiAnalyzer::new);
            MenuScreens.m_96206_(CoreMenuTypes.NATURALIST_INVENTORY.menuType(), GuiNaturalistInventory::new);
            MenuScreens.m_96206_(CoreMenuTypes.ESCRITOIRE.menuType(), GuiEscritoire::new);
            MenuScreens.m_96206_(CoreMenuTypes.SOLDERING_IRON.menuType(), GuiSolderingIron::new);
        });
        bewlr = new ForestryBewlr(Minecraft.m_91087_().m_167982_());
    }

    private static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("fluid_container", (IGeometryLoader)FluidContainerModel.Loader.INSTANCE);
        PluginManager.registerClient();
    }

    private static void bakeModels(ModelEvent.BakingCompleted event) {
        ClientManager.INSTANCE.onBakeModels(event);
    }

    private static void setupLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ForestryModelLayers.ANALYZER_LAYER, RenderAnalyzer::createBodyLayer);
        event.registerLayerDefinition(ForestryModelLayers.MACHINE_LAYER, RenderMachine::createBodyLayer);
        event.registerLayerDefinition(ForestryModelLayers.NATURALIST_CHEST_LAYER, RenderNaturalistChest::createBodyLayer);
        event.registerLayerDefinition(ForestryModelLayers.ESCRITOIRE_LAYER, RenderEscritoire::createBodyLayer);
        event.registerLayerDefinition(ForestryModelLayers.MILL_LAYER, RenderMill::createBodyLayer);
        event.registerLayerDefinition(ForestryModelLayers.ENGINE_LAYER, RenderEngine::createBodyLayer);
    }

    private static void clientSetupRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(CoreTiles.ANALYZER.tileType(), RenderAnalyzer::new);
        event.registerBlockEntityRenderer(CoreTiles.ESCRITOIRE.tileType(), RenderEscritoire::new);
        event.registerBlockEntityRenderer(CoreTiles.APIARIST_CHEST.tileType(), ctx -> new RenderNaturalistChest(ctx, "apiaristchest"));
        event.registerBlockEntityRenderer(CoreTiles.ARBORIST_CHEST.tileType(), ctx -> new RenderNaturalistChest(ctx, "arbchest"));
        event.registerBlockEntityRenderer(CoreTiles.LEPIDOPTERIST_CHEST.tileType(), ctx -> new RenderNaturalistChest(ctx, "lepichest"));
        event.registerBlockEntityRenderer(EnergyTiles.CLOCKWORK_ENGINE.tileType(), ctx -> new RenderEngine(ctx, "textures/block/engine_clock_"));
        event.registerBlockEntityRenderer(EnergyTiles.BIOGAS_ENGINE.tileType(), ctx -> new RenderEngine(ctx, "textures/block/engine_bronze_"));
        event.registerBlockEntityRenderer(EnergyTiles.PEAT_ENGINE.tileType(), ctx -> new RenderEngine(ctx, "textures/block/engine_copper_"));
        event.registerBlockEntityRenderer(FactoryTiles.BOTTLER.tileType(), ctx -> new RenderMachine(ctx, "textures/block/bottler_"));
        event.registerBlockEntityRenderer(FactoryTiles.CARPENTER.tileType(), ctx -> new RenderMachine(ctx, "textures/block/carpenter_"));
        event.registerBlockEntityRenderer(FactoryTiles.CENTRIFUGE.tileType(), ctx -> new RenderMachine(ctx, "textures/block/centrifuge_"));
        event.registerBlockEntityRenderer(FactoryTiles.FERMENTER.tileType(), ctx -> new RenderMachine(ctx, "textures/block/fermenter_"));
        event.registerBlockEntityRenderer(FactoryTiles.MOISTENER.tileType(), ctx -> new RenderMachine(ctx, "textures/block/moistener_"));
        event.registerBlockEntityRenderer(FactoryTiles.SQUEEZER.tileType(), ctx -> new RenderMachine(ctx, "textures/block/squeezer_"));
        event.registerBlockEntityRenderer(FactoryTiles.STILL.tileType(), ctx -> new RenderMachine(ctx, "textures/block/still_"));
        event.registerBlockEntityRenderer(FactoryTiles.RAINMAKER.tileType(), ctx -> new RenderMill(ctx, "textures/block/rainmaker_"));
    }

    private static void handleTextureRemap(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            ModelBlockCached.clear();
        }
    }

    private static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ForestryTextureManager)IForestryClientApi.INSTANCE.getTextureManager()).getSpriteUploader());
        event.registerReloadListener((PreparableReloadListener)ColourProperties.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)GuiElementFactory.INSTANCE);
        ((ForestryTextureManager)IForestryClientApi.INSTANCE.getTextureManager()).init();
    }

    private static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register(ClientManager.FORESTRY_BLOCK_COLOR, ApicultureBlocks.BEE_COMB.blockArray());
        event.register(ClientManager.FORESTRY_BLOCK_COLOR, new Block[]{ArboricultureBlocks.LEAVES.block()});
        event.register(ClientManager.FORESTRY_BLOCK_COLOR, ArboricultureBlocks.LEAVES_DEFAULT.blockArray());
        event.register(ClientManager.FORESTRY_BLOCK_COLOR, ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.blockArray());
        event.register(ClientManager.FORESTRY_BLOCK_COLOR, ArboricultureBlocks.LEAVES_DECORATIVE.blockArray());
    }

    private static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])CoreItems.ELECTRON_TUBES.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])CoreItems.CIRCUITBOARDS.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])FluidsItems.CONTAINERS.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{CoreItems.PIPETTE.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ApicultureBlocks.BEE_COMB.blockArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{ApicultureItems.BEE_QUEEN.item(), ApicultureItems.BEE_DRONE.item(), ApicultureItems.BEE_PRINCESS.item(), ApicultureItems.BEE_LARVAE.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ApicultureItems.HONEY_DROPS.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ApicultureItems.PROPOLIS.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ApicultureItems.POLLEN_CLUSTER.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ApicultureItems.BEE_COMBS.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{ArboricultureBlocks.LEAVES.block()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ArboricultureBlocks.LEAVES_DEFAULT.blockArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.blockArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])ArboricultureBlocks.LEAVES_DECORATIVE.blockArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{ArboricultureItems.SAPLING.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{ArboricultureItems.POLLEN_FERTILE.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{LepidopterologyItems.CATERPILLAR_GE.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{LepidopterologyItems.SERUM_GE.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{BackpackItems.APIARIST_BACKPACK.item(), BackpackItems.ARBORIST_BACKPACK.item(), BackpackItems.LEPIDOPTERIST_BACKPACK.item(), BackpackItems.MINER_BACKPACK.item(), BackpackItems.MINER_BACKPACK_T_2.item(), BackpackItems.DIGGER_BACKPACK.item(), BackpackItems.DIGGER_BACKPACK_T_2.item(), BackpackItems.FORESTER_BACKPACK.item(), BackpackItems.FORESTER_BACKPACK_T_2.item(), BackpackItems.HUNTER_BACKPACK.item(), BackpackItems.HUNTER_BACKPACK_T_2.item(), BackpackItems.ADVENTURER_BACKPACK.item(), BackpackItems.ADVENTURER_BACKPACK_T_2.item(), BackpackItems.BUILDER_BACKPACK.item(), BackpackItems.BUILDER_BACKPACK_T_2.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])CrateItems.CRATED_BEE_COMBS.itemArray());
        event.register(ClientManager.FORESTRY_ITEM_COLOR, new ItemLike[]{CrateItems.CRATED_GRASS_BLOCK.item(), CrateItems.CRATED_POLLEN_CLUSTER_NORMAL.item(), CrateItems.CRATED_POLLEN_CLUSTER_CRYSTALLINE.item(), CrateItems.CRATED_PROPOLIS.item()});
        event.register(ClientManager.FORESTRY_ITEM_COLOR, (ItemLike[])MailItems.STAMPS.itemArray());
    }

    private static void onClientTick(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && GeneticsUtil.hasNaturalistEye((Player)player)) {
                PoseStack stack = event.getPoseStack();
                Vec3 cameraPos = event.getCamera().m_90583_();
                RENDER_TYPE_LINES_XRAY.m_110188_();
                RENDER_TYPE_LINES_XRAY.m_110185_();
                MultiBufferSource.BufferSource buffers = minecraft.m_91269_().m_110104_();
                VertexConsumer lines = buffers.m_6299_(RENDER_TYPE_LINES_XRAY);
                int renderDistance = (Integer)minecraft.f_91066_.m_231984_().m_231551_();
                BlockPos playerPos = minecraft.f_91074_.m_20183_();
                ChunkPos playerChunkPos = new ChunkPos(playerPos);
                Color color = RenderUtil.getRainbowColor(minecraft.f_91073_.m_46467_(), event.getPartialTick());
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                for (int chunkX = playerChunkPos.f_45578_ - renderDistance; chunkX <= playerChunkPos.f_45578_ + renderDistance; ++chunkX) {
                    for (int chunkZ = playerChunkPos.f_45579_ - renderDistance; chunkZ <= playerChunkPos.f_45579_ + renderDistance; ++chunkZ) {
                        LevelChunk chunk = minecraft.f_91073_.m_6325_(chunkX, chunkZ);
                        for (BlockEntity be : chunk.m_62954_().values()) {
                            ISpectacleBlock naturalist;
                            if (!(be instanceof ISpectacleBlock) || !(naturalist = (ISpectacleBlock)be).isHighlighted((Player)player)) continue;
                            BlockPos pos = be.m_58899_();
                            stack.m_85836_();
                            stack.m_85837_((double)pos.m_123341_() - cameraPos.f_82479_, (double)pos.m_123342_() - cameraPos.f_82480_, (double)pos.m_123343_() - cameraPos.f_82481_);
                            LevelRenderer.m_109608_((PoseStack)stack, (VertexConsumer)lines, (double)-0.001, (double)-0.001, (double)-0.001, (double)1.001, (double)1.001, (double)1.001, (float)r, (float)g, (float)b, (float)1.0f);
                            stack.m_85849_();
                        }
                    }
                }
                buffers.m_109911_();
            }
        }
    }

    static {
        RENDER_TYPE_LINES_XRAY = RenderType.m_173215_((String)"lines_xray", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(RenderStateShard.f_110119_).m_110685_(RenderStateShard.f_110139_).m_110675_(RenderStateShard.f_110124_).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
    }
}

