/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.ClimateState;
import forestry.api.climate.IClimateManager;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.core.climate.ClimateProvider;
import forestry.core.climate.FakeClimateProvider;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.ApiStatus;

public class ForestryClimateManager
implements IClimateManager {
    private final IdentityHashMap<ResourceKey<Biome>, TemperatureType> temperatures = new IdentityHashMap();
    private final IdentityHashMap<ResourceKey<Biome>, HumidityType> humidities = new IdentityHashMap();

    @Override
    public TemperatureType getTemperature(Holder<Biome> biome) {
        ResourceKey resourceKey;
        if (biome instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)biome;
            resourceKey = reference.m_205785_();
        } else {
            resourceKey = (ResourceKey)biome.m_203543_().get();
        }
        return this.getTemperature((ResourceKey<Biome>)resourceKey);
    }

    @Override
    public TemperatureType getTemperature(ResourceKey<Biome> biome) {
        return this.temperatures.get(biome);
    }

    @Override
    public HumidityType getHumidity(Holder<Biome> biome) {
        ResourceKey resourceKey;
        if (biome instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)biome;
            resourceKey = reference.m_205785_();
        } else {
            resourceKey = (ResourceKey)biome.m_203543_().get();
        }
        return this.getHumidity((ResourceKey<Biome>)resourceKey);
    }

    @Override
    public HumidityType getHumidity(ResourceKey<Biome> biome) {
        return this.humidities.get(biome);
    }

    @Override
    public IClimateProvider createClimateProvider(LevelReader world, BlockPos pos) {
        return new ClimateProvider(world, pos);
    }

    @Override
    public IClimateProvider createDummyClimateProvider() {
        return FakeClimateProvider.INSTANCE;
    }

    @Override
    public ClimateState getState(ServerLevel level, BlockPos pos) {
        return this.getBiomeState((LevelReader)level, pos);
    }

    @Override
    public ClimateState getBiomeState(LevelReader level, BlockPos coordinates) {
        Holder biome = level.m_204166_(coordinates);
        return new ClimateState(this.getTemperature((Holder<Biome>)biome), this.getHumidity((Holder<Biome>)biome));
    }

    @ApiStatus.Internal
    public void onBiomesReloaded(Registry<Biome> registry) {
        this.temperatures.clear();
        this.humidities.clear();
        registry.m_203611_().forEach(holder -> {
            boolean hasTemperatureTag = false;
            boolean hasHumidityTag = false;
            for (TemperatureType temperature : TemperatureType.VALUES) {
                if (!holder.m_203656_(temperature.tag)) continue;
                this.temperatures.put((ResourceKey<Biome>)holder.m_205785_(), temperature);
                hasTemperatureTag = true;
                break;
            }
            for (HumidityType humidity : HumidityType.VALUES) {
                if (!holder.m_203656_(humidity.tag)) continue;
                this.humidities.put((ResourceKey<Biome>)holder.m_205785_(), humidity);
                hasHumidityTag = true;
                break;
            }
            if (!hasTemperatureTag) {
                this.temperatures.put((ResourceKey<Biome>)holder.m_205785_(), TemperatureType.getFromValue(((Biome)holder.m_203334_()).m_47554_()));
            }
            if (!hasHumidityTag) {
                this.humidities.put((ResourceKey<Biome>)holder.m_205785_(), HumidityType.getFromValue(((Biome)holder.m_203334_()).m_47548_()));
            }
        });
    }
}

