/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import forestry.api.IForestryApi;
import forestry.api.genetics.ISpeciesType;
import java.util.function.Function;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public interface ISpeciesArgumentType<A>
extends ArgumentType<A> {
    public ISpeciesType<?, ?> type();

    public static class Serializer<A extends ISpeciesArgumentType<?>>
    implements ArgumentTypeInfo<A, Template> {
        private final Function<ISpeciesType<?, ?>, A> factory;

        public Serializer(Function<ISpeciesType<?, ?>, A> factory) {
            this.factory = factory;
        }

        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.m_130085_(template.type.id());
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template(IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(buffer.m_130281_()));
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("species_type", template.type.id().toString());
        }

        public Template unpack(A argument) {
            return new Template(argument.type());
        }

        public class Template
        implements ArgumentTypeInfo.Template<A> {
            private final ISpeciesType<?, ?> type;

            public Template(ISpeciesType<?, ?> type) {
                this.type = type;
            }

            public A instantiate(CommandBuildContext context) {
                return (ISpeciesArgumentType)Serializer.this.factory.apply(this.type);
            }

            public ArgumentTypeInfo<A, Template> m_213709_() {
                return Serializer.this;
            }
        }
    }
}

