/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import forestry.api.ForestryConstants;
import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.genetics.ILifeStage;
import forestry.apiculture.features.ApicultureItems;
import forestry.core.utils.SpeciesUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.commands.CommandFunction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForestryAdvancementProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;

    public ForestryAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        Path outputFolder = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        this.build(advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path = ForestryAdvancementProvider.createPath(outputFolder, advancement);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private void build(Consumer<Advancement> consumer) {
        ItemStack icon = new ItemStack((ItemLike)ApicultureItems.BEE_QUEEN.item());
        ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).createStack(ForestryBeeSpecies.INDUSTRIOUS, (ILifeStage)BeeLifeStage.QUEEN);
        Advancement.Builder.m_138353_().m_138362_(icon, (Component)Component.m_237115_((String)"advancements.forestry.root.title"), (Component)Component.m_237115_((String)"advancements.forestry.root.description"), new ResourceLocation("textures/block/honeycomb_block.png"), FrameType.TASK, false, false, false).m_138386_("tick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])ApicultureItems.BEE_COMBS.itemArray())).m_138356_(new AdvancementRewards(0, new ResourceLocation[]{ForestryConstants.forestry("grant_guide")}, new ResourceLocation[0], CommandFunction.CacheableFunction.f_77990_)).m_138389_(consumer, "forestry:root");
    }

    private static Path createPath(Path outputFolder, Advancement advancement) {
        return outputFolder.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Advancements";
    }
}

