/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Sets;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.blocks.BlockForestryDoor;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.arboriculture.loot.CountBlockFunction;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.loot.OrganismFunction;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.ModFeatureRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ForestryBlockLootTables
extends BlockLoot {
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        for (BlockDecorativeLeaves blockDecorativeLeaves : ArboricultureBlocks.LEAVES_DECORATIVE.getBlocks()) {
            this.m_124175_(blockDecorativeLeaves, block -> ForestryBlockLootTables.droppingWithChances(block, blockDecorativeLeaves.getType(), f_124068_));
        }
        for (BlockDefaultLeaves blockDefaultLeaves : ArboricultureBlocks.LEAVES_DEFAULT.getBlocks()) {
            this.m_124175_((Block)blockDefaultLeaves, block -> ForestryBlockLootTables.droppingWithChances(block, blockDefaultLeaves.getType(), f_124068_));
        }
        for (Map.Entry entry : ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getFeatureByType().entrySet()) {
            FeatureBlock defaultLeaves = (FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get((ForestryLeafType)entry.getKey());
            Object defaultLeavesBlock = defaultLeaves.block();
            Object fruitLeavesBlock = ((FeatureBlock)entry.getValue()).block();
            this.m_124175_((Block)fruitLeavesBlock, block -> ForestryBlockLootTables.droppingWithChances(defaultLeavesBlock, (ForestryLeafType)entry.getKey(), f_124068_));
        }
        for (BlockForestryDoor blockForestryDoor : ArboricultureBlocks.DOORS.getBlocks()) {
            this.m_124165_((Block)blockForestryDoor, BlockLoot.m_124137_((Block)blockForestryDoor));
        }
        this.registerLootTable(CharcoalBlocks.ASH, block -> LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(CoreItems.ASH)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)2, (float)0.33333334f)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42414_)).m_79078_(CountBlockFunction.builder()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.575f, (int)2))));
        this.registerLootTable(CoreBlocks.PEAT, block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50493_))).m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CoreItems.PEAT.item()))));
        this.registerDropping(CoreBlocks.HUMUS, (ItemLike)Blocks.f_50493_);
        this.registerEmptyTables(ArboricultureBlocks.PODS);
        this.registerEmptyTables(ArboricultureBlocks.SAPLING_GE);
        this.registerEmptyTables(ArboricultureBlocks.LEAVES);
        this.registerEmptyTables(LepidopterologyBlocks.COCOON);
        this.registerEmptyTables(LepidopterologyBlocks.COCOON_SOLID);
        this.registerLootTable(CoreBlocks.APATITE_ORE, ForestryBlockLootTables::createApatiteOreDrops);
        this.registerLootTable(CoreBlocks.DEEPSLATE_APATITE_ORE, ForestryBlockLootTables::createApatiteOreDrops);
        this.registerLootTable(CoreBlocks.TIN_ORE, block -> ForestryBlockLootTables.m_124139_((Block)block, (Item)CoreItems.RAW_TIN.item()));
        this.registerLootTable(CoreBlocks.DEEPSLATE_TIN_ORE, block -> ForestryBlockLootTables.m_124139_((Block)block, (Item)CoreItems.RAW_TIN.item()));
        this.m_124288_(CoreBlocks.RAW_TIN_BLOCK.block());
        HashSet visited = Sets.newHashSet();
        ModFeatureRegistry modFeatureRegistry = ModFeatureRegistry.getRegistries().get("forestry");
        modFeatureRegistry.getModules().values().stream().flatMap(module -> module.getFeatures(Registry.f_122901_).stream()).forEach(feature -> {
            if (feature instanceof FeatureBlock) {
                FeatureBlock blockFeature = (FeatureBlock)feature;
                Object block = blockFeature.block();
                ResourceLocation resourcelocation = block.m_60589_();
                if (resourcelocation != BuiltInLootTables.f_78712_ && visited.add(resourcelocation)) {
                    LootTable.Builder builder = (LootTable.Builder)this.f_124070_.remove(resourcelocation);
                    if (builder == null) {
                        builder = ForestryBlockLootTables.m_124126_(block);
                    }
                    consumer.accept(resourcelocation, builder);
                }
            } else {
                throw new IllegalStateException("Found feature in BLOCK_REGISTRY that is not FeatureBlock.");
            }
        });
        if (!this.f_124070_.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.f_124070_.keySet());
        }
    }

    private static LootTable.Builder createApatiteOreDrops(Block block) {
        return ForestryBlockLootTables.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)ForestryBlockLootTables.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)CoreItems.APATITE.item()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)7.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2)))));
    }

    public static LootTable.Builder droppingWithChances(Block block, ForestryLeafType definition, float ... chances) {
        return ForestryBlockLootTables.m_124283_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)ForestryBlockLootTables.m_236224_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_(ArboricultureItems.SAPLING).m_79078_(OrganismFunction.fromId(((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).id(), definition.getSpeciesId())))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])chances)));
    }

    public void registerLootTable(FeatureBlock<?, ?> featureBlock, Function<Block, LootTable.Builder> builderFunction) {
        this.m_124175_((Block)featureBlock.block(), builderFunction);
    }

    public void registerDropping(FeatureBlock<?, ?> featureBlock, ItemLike drop) {
        this.m_124147_((Block)featureBlock.block(), drop);
    }

    public void registerEmptyTables(FeatureBlockGroup<?, ?> blockGroup) {
        this.registerEmptyTables(blockGroup.blockArray());
    }

    public void registerEmptyTables(FeatureBlock<?, ?> featureBlock) {
        this.registerEmptyTables(new Block[]{featureBlock.block()});
    }

    public void registerEmptyTables(Block ... blocks) {
        for (Block block : blocks) {
            this.m_124165_(block, ForestryBlockLootTables.m_124125_());
        }
    }
}

