/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import forestry.Forestry;
import forestry.core.data.ForestryBlockLootTables;
import forestry.core.data.ForestryChestLootTables;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForestryLootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(ForestryBlockLootTables::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(ForestryChestLootTables::new, (Object)LootContextParamSets.f_81411_));

    public ForestryLootTableProvider(DataGenerator dataGeneratorIn) {
        this.dataGenerator = dataGeneratorIn;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        Path path = this.dataGenerator.m_123916_();
        HashMap map = Maps.newHashMap();
        this.tables.forEach(entry -> ((Consumer)((Supplier)entry.getFirst()).get()).accept((location, builder) -> {
            if (map.put(location, builder.m_79165_((LootContextParamSet)entry.getSecond()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + location);
            }
        }));
        ValidationContext validationtracker = new ValidationContext(LootContextParamSets.f_81420_, location -> null, map::get);
        this.validate(map, validationtracker);
        Multimap multimap = validationtracker.m_79352_();
        if (!multimap.isEmpty()) {
            multimap.forEach((location, message) -> Forestry.LOGGER.warn("Found validation problem in {}: {}", location, message));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((location, table) -> {
            Path path1 = ForestryLootTableProvider.getPath(path, location);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)table), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save loot table {}", (Object)path1, (Object)ioexception);
            }
        });
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext tracker) {
        map.forEach((location, loot) -> LootTables.m_79202_((ValidationContext)tracker, (ResourceLocation)location, (LootTable)loot));
    }

    private static Path getPath(Path path, ResourceLocation id) {
        return path.resolve("data/" + id.m_135827_() + "/loot_tables/" + id.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Forestry LootTables";
    }
}

