/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import forestry.api.ForestryTags;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.circuits.ICircuit;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumHoneyDrop;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.EnumPropolis;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.VanillaWoodType;
import forestry.core.blocks.BlockTypeCoreTesr;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.data.builder.CarpenterRecipeBuilder;
import forestry.core.data.builder.CentrifugeRecipeBuilder;
import forestry.core.data.builder.FabricatorRecipeBuilder;
import forestry.core.data.builder.FabricatorSmeltingRecipeBuilder;
import forestry.core.data.builder.FermenterRecipeBuilder;
import forestry.core.data.builder.HygroregulatorRecipeBuilder;
import forestry.core.data.builder.MoistenerRecipeBuilder;
import forestry.core.data.builder.SqueezerContainerRecipeBuilder;
import forestry.core.data.builder.SqueezerRecipeBuilder;
import forestry.core.data.builder.StillRecipeBuilder;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.features.FluidsItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.core.utils.ModUtil;
import forestry.mail.features.MailItems;
import forestry.mail.items.ItemLetter;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import forestry.storage.features.BackpackItems;
import forestry.storage.features.CrateItems;
import forestry.storage.items.ItemCrated;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class ForestryMachineRecipeProvider
extends RecipeProvider {
    public static final int STILL_DESTILLATION_DURATION = 100;
    public static final int STILL_DESTILLATION_INPUT = 10;
    public static final int STILL_DESTILLATION_OUTPUT = 3;

    public ForestryMachineRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String m_6055_() {
        return "Machine Recipes";
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.registerCarpenter(consumer);
        this.registerCentrifuge(consumer);
        this.registerFabricator(consumer);
        this.registerFabricatorSmelting(consumer);
        this.registerFermenter(consumer);
        this.registerHygroregulator(consumer);
        this.registerMoistener(consumer);
        this.registerSqueezerContainer(consumer);
        this.registerSqueezer(consumer);
        this.registerStill(consumer);
    }

    private void registerCarpenter(Consumer<FinishedRecipe> consumer) {
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(250)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.IMPREGNATED_CASING).m_126130_("###").m_126130_("# #").m_126130_("###").m_206416_(Character.valueOf('#'), ItemTags.f_13182_)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "impregnated_casing"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(500)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(((FeatureBlock)CoreBlocks.BASE.get(BlockTypeCoreTesr.ESCRITOIRE)).item()).m_126130_("#  ").m_126130_("###").m_126130_("# #").m_206416_(Character.valueOf('#'), ItemTags.f_13168_)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "escritoire"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(100)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126118_(CoreItems.STICK_IMPREGNATED, (int)2).m_126130_("#").m_126130_("#").m_206416_(Character.valueOf('#'), ItemTags.f_13182_)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "impregnated_stick"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 250)).setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_126191_(CoreItems.WOOD_PULP, (int)4).m_206419_(ItemTags.f_13182_)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "wood_pulp"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126118_(CoreBlocks.HUMUS, (int)9).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('X'), CoreItems.MULCH)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "humus"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126118_(CoreBlocks.BOG_EARTH, (int)8).m_126130_("#X#").m_126130_("XYX").m_126130_("#X#").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42329_).m_206416_(Character.valueOf('X'), Tags.Items.SAND).m_126127_(Character.valueOf('Y'), CoreItems.MULCH)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "bog_earth"));
        new CarpenterRecipeBuilder().setPackagingTime(75).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 5000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.HARDENED_CASING).m_126130_("X X").m_126130_(" Y ").m_126130_("X X").m_206416_(Character.valueOf('X'), Tags.Items.GEMS_DIAMOND).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "hardened_casing"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.IODINE_CHARGE).m_126130_("Z#Z").m_126130_("#Y#").m_126130_("X#X").m_126127_(Character.valueOf('#'), (ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42403_).m_126127_(Character.valueOf('Y'), (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).m_126127_(Character.valueOf('Z'), (ItemLike)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "iodine_charge"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.DISSIPATION_CHARGE))).m_126130_("Z#Z").m_126130_("#Y#").m_126130_("X#X").m_126127_(Character.valueOf('#'), ApicultureItems.ROYAL_JELLY).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42403_).m_126127_(Character.valueOf('Y'), (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).m_126127_(Character.valueOf('Z'), ApicultureItems.HONEYDEW)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "dissipation_charge"));
        new CarpenterRecipeBuilder().setPackagingTime(100).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42584_).m_126130_(" # ").m_126130_("###").m_126130_(" # ").m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.PULSATING_MESH))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "ender_pearl"));
        new CarpenterRecipeBuilder().setPackagingTime(10).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 500)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK))).m_126130_("XXX").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "woven_silk"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_126191_(CoreItems.INGOT_BRONZE, (int)2).m_126209_(CoreItems.BROKEN_BRONZE_PICKAXE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "reclaim_bronze_pickaxe"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_126191_(CoreItems.INGOT_BRONZE, (int)1).m_126209_(CoreItems.BROKEN_BRONZE_SHOVEL)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "reclaim_bronze_shovel"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.HONEY.getFluid(500)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SCENTED_PANELING))).m_126130_(" J ").m_126130_("###").m_126130_("WPW").m_206416_(Character.valueOf('#'), ItemTags.f_13168_).m_126127_(Character.valueOf('J'), ApicultureItems.ROYAL_JELLY).m_126127_(Character.valueOf('W'), CoreItems.BEESWAX).m_126127_(Character.valueOf('P'), (ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "scented_paneling"));
        new CarpenterRecipeBuilder().setPackagingTime(100).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 2000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.PORTABLE_ALYZER).m_126130_("X#X").m_126130_("X#X").m_126130_("RDR").m_206416_(Character.valueOf('#'), Tags.Items.GLASS_PANES).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "portable_analyzer"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.KIT_PICKAXE).m_126130_("###").m_126130_(" X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "kit_pickaxe"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.KIT_SHOVEL).m_126130_(" # ").m_126130_(" X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "kit_shovel"));
        new CarpenterRecipeBuilder().setPackagingTime(40).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.SOLDERING_IRON).m_126130_(" # ").m_126130_("# #").m_126130_("  B").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('B'), ForestryTags.Items.INGOTS_BRONZE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "soldering_iron"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 250)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42516_).m_126130_("#").m_126130_("#").m_126127_(Character.valueOf('#'), CoreItems.WOOD_PULP)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "paper"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126118_(CoreItems.CARTON, (int)2).m_126130_(" # ").m_126130_("# #").m_126130_(" # ").m_126127_(Character.valueOf('#'), CoreItems.WOOD_PULP)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "carton"));
        ItemStack basic = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]);
        ItemStack enhanced = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]);
        ItemStack refined = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]);
        ItemStack intricate = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]);
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(basic).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.BASIC))).m_126130_("R R").m_126130_("R#R").m_126130_("R R").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "basic"));
        new CarpenterRecipeBuilder().setPackagingTime(40).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(enhanced).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.ENHANCED))).m_126130_("R#R").m_126130_("R#R").m_126130_("R#R").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "enhanced"));
        new CarpenterRecipeBuilder().setPackagingTime(80).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(refined).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.REFINED))).m_126130_("R#R").m_126130_("R#R").m_126130_("R#R").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "refined"));
        new CarpenterRecipeBuilder().setPackagingTime(80).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(intricate).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.INTRICATE))).m_126130_("R#R").m_126130_("R#R").m_126130_("R#R").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "intricate"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126118_(CrateItems.CRATE, (int)24).m_126130_(" # ").m_126130_("# #").m_126130_(" # ").m_206416_(Character.valueOf('#'), ItemTags.f_13182_)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "crates", "empty"));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_PEAT.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PEAT}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_APATITE.get(), Ingredient.m_204132_(ForestryTags.Items.GEMS_APATITE));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_FERTILIZER_COMPOUND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.FERTILIZER_COMPOUND}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_MULCH.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.MULCH}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_PHOSPHOR.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PHOSPHOR}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_ASH.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.ASH}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_TIN.get(), Ingredient.m_204132_(ForestryTags.Items.INGOTS_TIN));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_COPPER.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_BRONZE.get(), Ingredient.m_204132_(ForestryTags.Items.INGOTS_BRONZE));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_HUMUS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreBlocks.HUMUS}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_BOG_EARTH.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreBlocks.BOG_EARTH}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_WHEAT.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_WHEAT));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_COOKIE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42572_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_REDSTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_LAPIS.get(), Ingredient.m_204132_((TagKey)Tags.Items.GEMS_LAPIS));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_SUGAR_CANE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_CLAY_BALL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_GLOWSTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_GLOWSTONE));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_APPLE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_COAL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_CHARCOAL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42414_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_SEEDS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_POTATO.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_POTATO));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_CARROT.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_CARROT));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_BEETROOT.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_BEETROOT));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_NETHER_WART.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_NETHER_WART));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_OAK_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41837_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_BIRCH_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41839_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_JUNGLE_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41840_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_SPRUCE_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41838_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_ACACIA_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41841_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_DARK_OAK_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41842_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_COBBLESTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.COBBLESTONE));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_DIRT.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42329_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_GRASS_BLOCK.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42276_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_STONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.STONE));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_GRANITE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41958_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_DIORITE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42064_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_ANDESITE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42170_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_PRISMARINE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42192_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_PRISMARINE_BRICKS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42193_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_DARK_PRISMARINE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42194_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_BRICKS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41995_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_CACTUS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_SAND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41830_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_RED_SAND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41831_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_OBSIDIAN.get(), Ingredient.m_204132_((TagKey)Tags.Items.OBSIDIAN));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_NETHERRACK.get(), Ingredient.m_204132_((TagKey)Tags.Items.NETHERRACK));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_SOUL_SAND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42049_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_SANDSTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.SANDSTONE));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_NETHER_BRICKS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42095_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_MYCELIUM.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42093_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_GRAVEL.get(), Ingredient.m_204132_((TagKey)Tags.Items.GRAVEL));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_OAK_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42799_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_BIRCH_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42801_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_JUNGLE_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41826_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_SPRUCE_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42800_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_ACACIA_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41827_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_DARK_OAK_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41828_}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_BEESWAX.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.BEESWAX}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_REFRACTORY_WAX.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.REFRACTORY_WAX}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_POLLEN_CLUSTER_NORMAL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_POLLEN_CLUSTER_CRYSTALLINE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.CRYSTALLINE)}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_PROPOLIS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL)}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_HONEYDEW.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.HONEYDEW}));
        this.crate(consumer, (ItemCrated)CrateItems.CRATED_ROYAL_JELLY.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.ROYAL_JELLY}));
        for (EnumHoneyComb comb : EnumHoneyComb.VALUES) {
            this.crate(consumer, (ItemCrated)((FeatureItem)CrateItems.CRATED_BEE_COMBS.get(comb)).get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(comb)}));
        }
        new CarpenterRecipeBuilder().setPackagingTime(10).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 250)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(((FeatureItem)MailItems.LETTERS.get(ItemLetter.Size.EMPTY, ItemLetter.State.FRESH)).item()).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), CoreItems.WOOD_PULP)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "letter_pulp"));
        this.wovenBackpack(consumer, "miner", BackpackItems.MINER_BACKPACK, BackpackItems.MINER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "digger", BackpackItems.DIGGER_BACKPACK, BackpackItems.DIGGER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "forester", BackpackItems.FORESTER_BACKPACK, BackpackItems.FORESTER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "hunter", BackpackItems.HUNTER_BACKPACK, BackpackItems.HUNTER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "adventurer", BackpackItems.ADVENTURER_BACKPACK, BackpackItems.ADVENTURER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "builder", BackpackItems.BUILDER_BACKPACK, BackpackItems.BUILDER_BACKPACK_T_2);
    }

    private void wovenBackpack(Consumer<FinishedRecipe> consumer, String id, FeatureItem<?> tier1, FeatureItem<?> tier2) {
        new CarpenterRecipeBuilder().setPackagingTime(200).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_126116_(tier2).m_126130_("WXW").m_126130_("WTW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.WOVEN_SILK).m_41720_()).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('T'), tier1)).build(consumer, ForestryMachineRecipeProvider.id("woven_backpack", id));
    }

    private void crate(Consumer<FinishedRecipe> consumer, ItemCrated crated, Ingredient ingredient) {
        ItemStack contained = crated.getContained();
        ResourceLocation name = ModUtil.getRegistryName(contained.m_41720_());
        if (name == null) {
            return;
        }
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 100)).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CrateItems.CRATE})).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)crated, (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126124_(Character.valueOf('#'), ingredient)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "crates", "pack", name.m_135827_(), name.m_135815_()));
        new CarpenterRecipeBuilder().setPackagingTime(5).setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_126191_((ItemLike)contained.m_41720_(), (int)9).m_126209_((ItemLike)crated)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "crates", "unpack", name.m_135827_(), name.m_135815_()));
    }

    private void registerCentrifuge(Consumer<FinishedRecipe> consumer) {
        new CentrifugeRecipeBuilder().setProcessingTime(5).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})).product(0.15f, CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.SILK_WISP)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "string"));
        ItemStack honeyDrop = ApicultureItems.HONEY_DROPS.stack(EnumHoneyDrop.HONEY, 1);
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.HONEY)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "honey_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.COCOA)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.5f, new ItemStack((ItemLike)Items.f_42533_)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "cocoa_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.SIMMERING)})).product(1.0f, CoreItems.REFRACTORY_WAX.stack()).product(0.7f, CoreItems.PHOSPHOR.stack(2)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "simmering_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.STRINGY)})).product(1.0f, ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).product(0.4f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "stringy_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.DRIPPING)})).product(1.0f, ApicultureItems.HONEYDEW.stack()).product(0.4f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "dripping_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.FROZEN)})).product(0.8f, CoreItems.BEESWAX.stack()).product(0.7f, honeyDrop).product(0.4f, new ItemStack((ItemLike)Items.f_42452_)).product(0.2f, ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.CRYSTALLINE, 1)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "frozen_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.SILKY)})).product(1.0f, honeyDrop).product(0.8f, ApicultureItems.PROPOLIS.stack(EnumPropolis.SILKY, 1)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "silky_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.PARCHED)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "parched_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MYSTERIOUS)})).product(1.0f, ApicultureItems.PROPOLIS.stack(EnumPropolis.PULSATING, 1)).product(0.4f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "mysterious_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.POWDERY)})).product(0.2f, honeyDrop).product(0.2f, CoreItems.BEESWAX.stack()).product(0.9f, new ItemStack((ItemLike)Items.f_42403_)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "powdery_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.WHEATEN)})).product(0.2f, honeyDrop).product(0.2f, CoreItems.BEESWAX.stack()).product(0.8f, new ItemStack((ItemLike)Items.f_42405_)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "wheaten_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MOSSY)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "mossy_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.KAOLIN)})).product(1.0f, new ItemStack((ItemLike)Items.f_42461_)).product(0.9f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "kaolin_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MELLOW)})).product(0.6f, ApicultureItems.HONEYDEW.stack()).product(0.2f, CoreItems.BEESWAX.stack()).product(0.3f, new ItemStack((ItemLike)Items.f_42692_)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "mellow_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(5).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.SILKY)})).product(0.6f, CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.SILK_WISP, 1)).product(0.1f, ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "silky_propolis"));
    }

    private void registerFabricator(Consumer<FinishedRecipe> consumer) {
        FluidStack liquidGlass = ForestryFluids.GLASS.getFluid(500);
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.IRON)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_IRON)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "iron"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_GOLD)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "gold"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.DIAMOND)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.GEMS_DIAMOND)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "diamond"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.OBSIDIAN)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41999_)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "obsidian"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BLAZE)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42593_)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "blaze"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.EMERALD)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.GEMS_EMERALD)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "emerald"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.LAPIS)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.GEMS_LAPIS)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "lapis"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.ENDER)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42102_)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "ender"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.ORCHID)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42350_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41977_)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "orchid"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.COPPER)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_151052_)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "copper"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.TIN)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "tin"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BRONZE)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "bronze"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.APATITE)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEMS_APATITE)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "apatite"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126116_(CoreItems.FLEXIBLE_CASING).m_126130_("#E#").m_126130_("B B").m_126130_("#E#").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('B'), Tags.Items.SLIMEBALLS).m_206416_(Character.valueOf('E'), Tags.Items.GEMS_EMERALD)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "flexible_casing"));
        for (ForestryWoodType forestryWoodType : ForestryWoodType.values()) {
            this.addFireproofRecipes(consumer, forestryWoodType);
        }
        for (Enum enum_ : VanillaWoodType.values()) {
            this.addFireproofRecipes(consumer, (IWoodType)((Object)enum_));
        }
    }

    private void addFireproofRecipes(Consumer<FinishedRecipe> consumer, IWoodType type) {
        FluidStack liquidGlass = ForestryFluids.GLASS.getFluid(500);
        List<WoodBlockKind> logLike = List.of(WoodBlockKind.LOG, WoodBlockKind.WOOD, WoodBlockKind.STRIPPED_LOG, WoodBlockKind.STRIPPED_WOOD);
        for (WoodBlockKind woodKind : logLike) {
            try {
                new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126116_((ItemLike)TreeManager.woodAccess.getBlock(type, woodKind, true).m_60734_()).m_126130_(" # ").m_126130_("#X#").m_126130_(" # ").m_126127_(Character.valueOf('#'), CoreItems.REFRACTORY_WAX).m_126127_(Character.valueOf('X'), (ItemLike)TreeManager.woodAccess.getBlock(type, woodKind, false).m_60734_())).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "fireproof", woodKind.m_7912_(), type.toString()));
            }
            catch (IllegalStateException illegalStateException) {}
        }
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_126118_((ItemLike)TreeManager.woodAccess.getBlock(type, WoodBlockKind.PLANKS, true).m_60734_(), (int)5).m_126130_("X#X").m_126130_("#X#").m_126130_("X#X").m_126127_(Character.valueOf('#'), CoreItems.REFRACTORY_WAX).m_126127_(Character.valueOf('X'), (ItemLike)TreeManager.woodAccess.getBlock(type, WoodBlockKind.PLANKS, false).m_60734_())).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "fireproof", "planks", type.toString()));
    }

    private void registerFabricatorSmelting(Consumer<FinishedRecipe> consumer) {
        FluidStack liquidGlassBucket = ForestryFluids.GLASS.getFluid(1000);
        FluidStack liquidGlassX4 = ForestryFluids.GLASS.getFluid(4000);
        FluidStack liquidGlass375 = ForestryFluids.GLASS.getFluid(375);
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41904_})).setProduct(liquidGlassBucket).setMeltingPoint(1000).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "glass"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42027_})).setProduct(liquidGlass375).setMeltingPoint(1000).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "glass_pane"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41830_, Items.f_41831_})).setProduct(liquidGlassBucket).setMeltingPoint(3000).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "sand"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41856_, Items.f_41993_, Items.f_41857_})).setProduct(liquidGlassX4).setMeltingPoint(4800).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "sandstone"));
    }

    private void registerFermenter(Consumer<FinishedRecipe> consumer) {
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41952_})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.HONEY.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "brown_mushroom_honey"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41952_})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.JUICE.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "brown_mushroom_juice"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41953_})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.HONEY.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "red_mushroom_honey"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41953_})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.JUICE.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "red_mushroom_juice"));
        FluidStack shortMead = ForestryFluids.SHORT_MEAD.getFluid(1);
        FluidStack honey = ForestryFluids.HONEY.getFluid(1);
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.HONEYDEW})).setFermentationValue(500).setModifier(1.0f).setOutput(shortMead.getFluid()).setFluidResource(honey).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "honeydew"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_204132_((TagKey)ItemTags.f_13180_)).setFermentationValue(250).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.f_76193_, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "sapling"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_})).setFermentationValue(50).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.f_76193_, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "cactus"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_204132_((TagKey)Tags.Items.CROPS_WHEAT)).setFermentationValue(50).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.f_76193_, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "wheat"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_204132_((TagKey)Tags.Items.CROPS_POTATO)).setFermentationValue(100).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.f_76193_, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "potato"));
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_})).setFermentationValue(50).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.f_76193_, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "sugar_cane"));
    }

    private void registerHygroregulator(Consumer<FinishedRecipe> consumer) {
        new HygroregulatorRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1)).setTemperatureSteps(-1).setHumiditySteps(1).build(consumer, ForestryMachineRecipeProvider.id("hygroregulator", "water"));
        new HygroregulatorRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76195_, 1)).setTemperatureSteps(1).setHumiditySteps(-1).build(consumer, ForestryMachineRecipeProvider.id("hygroregulator", "lava"));
        new HygroregulatorRecipeBuilder().setLiquid(ForestryFluids.ICE.getFluid(1)).setRetainTime(10).setTemperatureSteps(-2).setHumiditySteps(2).build(consumer, ForestryMachineRecipeProvider.id("hygroregulator", "ice"));
    }

    private void registerMoistener(Consumer<FinishedRecipe> consumer) {
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_})).setProduct(new ItemStack((ItemLike)Items.f_42093_)).setTimePerItem(5000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "mycelium"));
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42594_})).setProduct(new ItemStack((ItemLike)Items.f_41998_)).setTimePerItem(20000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "mossy_cobblestone"));
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42018_})).setProduct(new ItemStack((ItemLike)Items.f_42019_)).setTimePerItem(20000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "mossy_stone_bricks"));
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41897_})).setProduct(new ItemStack((ItemLike)Items.f_42435_)).setTimePerItem(5000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "podzol"));
    }

    private void registerSqueezerContainer(Consumer<FinishedRecipe> consumer) {
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.CAN)).setRemnants(CoreItems.INGOT_TIN.stack()).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "container", "can"));
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.CAPSULE)).setRemnants(CoreItems.BEESWAX.stack()).setRemnantsChance(0.1f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "container", "capsule"));
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.REFRACTORY)).setRemnants(CoreItems.REFRACTORY_WAX.stack()).setRemnantsChance(0.1f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "container", "refractory"));
    }

    private void registerSqueezer(Consumer<FinishedRecipe> consumer) {
        FluidStack honeyDropFluid = ForestryFluids.HONEY.getFluid(100);
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY)}))).setFluidOutput(honeyDropFluid).setRemnants(ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "honey_drop"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.HONEYDEW}))).setFluidOutput(honeyDropFluid).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "honey_dew"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), ingredients -> {
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41830_, Items.f_41831_}));
        }))).setFluidOutput(new FluidStack((Fluid)Fluids.f_76195_, 2000)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "lava_sand"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), ingredients -> {
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42329_, Items.f_42594_}));
        }))).setFluidOutput(new FluidStack((Fluid)Fluids.f_76195_, 1600)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "lava"));
        int seedOilAmount = 10;
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_((TagKey)Tags.Items.SEEDS))).setFluidOutput(ForestryFluids.SEED_OIL.getFluid(seedOilAmount)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "seeds"));
        float mulchMultiplier = 0.2f;
        int juiceMultiplier = 200;
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42619_}))).setFluidOutput(ForestryFluids.JUICE.getFluid(juiceMultiplier)).setRemnants(CoreItems.MULCH.stack()).setRemnantsChance(mulchMultiplier).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "mulch"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}))).setFluidOutput(new FluidStack((Fluid)Fluids.f_76193_, 500)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "cactus"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), ingredients -> {
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42452_}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
        }))).setFluidOutput(ForestryFluids.ICE.getFluid(4000)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "ice"));
        int seedOilMultiplier = 10;
        ItemStack mulch = new ItemStack(CoreItems.MULCH);
        Fluid seedOil = ForestryFluids.SEED_OIL.getFluid();
        Fluid juice = ForestryFluids.JUICE.getFluid();
        new SqueezerRecipeBuilder().setProcessingTime(20).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.CHERRY))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 5)).setRemnants(mulch).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "cherry"));
        new SqueezerRecipeBuilder().setProcessingTime(60).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.WALNUT))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 18)).setRemnants(mulch).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "walnut"));
        new SqueezerRecipeBuilder().setProcessingTime(70).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.CHESTNUT))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 22)).setRemnants(mulch).setRemnantsChance(0.02f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "chestnut"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.LEMON))).setFluidOutput(new FluidStack(juice, juiceMultiplier * 2)).setRemnants(mulch).setRemnantsChance(mulchMultiplier / 2.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "lemon"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.PLUM))).setFluidOutput(new FluidStack(juice, juiceMultiplier / 2)).setRemnants(mulch).setRemnantsChance(mulchMultiplier * 3.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "plum"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.PAPAYA))).setFluidOutput(new FluidStack(juice, juiceMultiplier * 3)).setRemnants(mulch).setRemnantsChance(mulchMultiplier / 2.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "papaya"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.DATE))).setFluidOutput(new FluidStack(juice, juiceMultiplier / 4)).setRemnants(mulch).setRemnantsChance(mulchMultiplier).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "dates"));
    }

    private void registerStill(Consumer<FinishedRecipe> consumer) {
        FluidStack biomass = ForestryFluids.BIOMASS.getFluid(10);
        FluidStack ethanol = ForestryFluids.BIO_ETHANOL.getFluid(3);
        new StillRecipeBuilder().setTimePerUnit(100).setInput(biomass).setOutput(ethanol).build(consumer, ForestryMachineRecipeProvider.id("still", "ethanol"));
    }

    private static ResourceLocation id(String ... path) {
        return new ResourceLocation("forestry", String.join((CharSequence)"/", path));
    }
}

