/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import forestry.api.ForestryConstants;
import forestry.api.ForestryTags;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.circuits.ICircuit;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.blocks.NaturalistChestBlockType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumHoneyDrop;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.EnumPropolis;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.core.blocks.BlockTypeCoreTesr;
import forestry.core.blocks.EnumResourceType;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.features.FluidsItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.ItemForestry;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.core.utils.ModUtil;
import forestry.cultivation.blocks.BlockPlanter;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.energy.blocks.EngineBlockType;
import forestry.energy.features.EnergyBlocks;
import forestry.factory.blocks.BlockTypeFactoryPlain;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.features.FarmingBlocks;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.lepidopterology.features.LepidopterologyRecipes;
import forestry.mail.blocks.BlockTypeMail;
import forestry.mail.features.MailBlocks;
import forestry.mail.features.MailItems;
import forestry.mail.items.EnumStampDefinition;
import forestry.mail.items.ItemLetter;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import forestry.sorting.features.SortingBlocks;
import forestry.storage.features.BackpackItems;
import forestry.worktable.features.WorktableBlocks;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.util.TriConsumer;

public class ForestryRecipeProvider
extends RecipeProvider {
    public ForestryRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    public static ItemStack getContainer(EnumContainerType type, ForestryFluids fluid) {
        return ForestryRecipeProvider.getContainer(type, fluid.getFluid());
    }

    public static ItemStack getContainer(EnumContainerType type, Fluid fluid) {
        ItemStack container = FluidsItems.CONTAINERS.stack(type);
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        return fluidHandlerCap.map(handler -> {
            handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
            return container;
        }).orElse(ItemStack.f_41583_);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.registerArboricultureRecipes(consumer);
        this.registerApicultureRecipes(consumer);
        this.registerFoodRecipes(consumer);
        this.registerBackpackRecipes(consumer);
        this.registerCharcoalRecipes(consumer);
        this.registerCoreRecipes(consumer);
        this.registerBookRecipes(consumer);
        this.registerCultivationRecipes(consumer);
        this.registerFactoryRecipes(consumer);
        this.registerFarmingRecipes(consumer);
        this.registerFluidsRecipes(consumer);
        this.registerLepidopterologyRecipes(consumer);
        this.registerMailRecipes(consumer);
        this.registerSortingRecipes(consumer);
        this.registerWorktableRecipes(consumer);
        this.registerEnergyRecipes(consumer);
    }

    private void registerApicultureRecipes(Consumer<FinishedRecipe> helper) {
        this.registerCombRecipes(helper);
        BlockAlveary plain = (BlockAlveary)((Object)((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.PLAIN)).block());
        ItemLike goldElectronTube = (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD);
        ShapedRecipeBuilder.m_126116_((ItemLike)plain).m_126127_(Character.valueOf('X'), CoreItems.IMPREGNATED_CASING).m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SCENTED_PANELING)).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.IMPREGNATED_CASING)).m_126145_("alveary").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.FAN)).block()).m_126127_(Character.valueOf('#'), goldElectronTube).m_126127_(Character.valueOf('X'), (ItemLike)plain).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126130_("I I").m_126130_(" X ").m_126130_("I#I").m_126132_("has_plain", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)plain)).m_126145_("alveary").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.HEATER)).block()).m_126127_(Character.valueOf('#'), goldElectronTube).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('X'), (ItemLike)plain).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126130_("#I#").m_126130_(" X ").m_126130_("SSS").m_126132_("has_plain", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)plain)).m_126145_("alveary").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.HYGRO)).block()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('X'), (ItemLike)plain).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126130_("GIG").m_126130_("GXG").m_126130_("GIG").m_126132_("has_plain", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)plain)).m_126145_("alveary").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.SIEVE)).block()).m_126127_(Character.valueOf('W'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK)).m_126127_(Character.valueOf('X'), (ItemLike)plain).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126130_("III").m_126130_(" X ").m_126130_("WWW").m_126132_("has_plain", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)plain)).m_126145_("alveary").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.STABILISER)).block()).m_126127_(Character.valueOf('X'), (ItemLike)plain).m_206416_(Character.valueOf('G'), Tags.Items.GEMS_QUARTZ).m_126130_("G G").m_126130_("GXG").m_126130_("G G").m_126132_("has_plain", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)plain)).m_126145_("alveary").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.SWARMER)).block()).m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.DIAMOND)).m_126127_(Character.valueOf('X'), (ItemLike)plain).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_126130_("#G#").m_126130_(" X ").m_126130_("#G#").m_126132_("has_plain", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)plain)).m_126145_("alveary").m_176498_(helper);
        ItemLike wovenSilk = (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.APIARIST_HELMET).m_126127_(Character.valueOf('#'), wovenSilk).m_126130_("###").m_126130_("# #").m_126132_("has silk", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)wovenSilk)).m_126145_("apiarist_armour").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.APIARIST_CHEST).m_126127_(Character.valueOf('#'), wovenSilk).m_126130_("# #").m_126130_("###").m_126130_("###").m_126132_("has silk", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)wovenSilk)).m_126145_("apiarist_armour").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.APIARIST_LEGS).m_126127_(Character.valueOf('#'), wovenSilk).m_126130_("###").m_126130_("# #").m_126130_("# #").m_126132_("has silk", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)wovenSilk)).m_126145_("apiarist_armour").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.APIARIST_BOOTS).m_126127_(Character.valueOf('#'), wovenSilk).m_126130_("# #").m_126130_("# #").m_126132_("has silk", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)wovenSilk)).m_126145_("apiarist_armour").m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.APIARY)).block()).m_206416_(Character.valueOf('S'), ItemTags.f_13175_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126127_(Character.valueOf('C'), CoreItems.IMPREGNATED_CASING).m_126130_("SSS").m_126130_("PCP").m_126130_("PPP").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.IMPREGNATED_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.BEE_HOUSE)).block()).m_206416_(Character.valueOf('S'), ItemTags.f_13175_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_206416_(Character.valueOf('C'), ForestryTags.Items.BEE_COMBS).m_126130_("SSS").m_126130_("PCP").m_126130_("PPP").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.BEE_COMBS)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.APIARIST_CHEST))).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), ForestryTags.Items.BEE_COMBS).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_(" G ").m_126130_("XYX").m_126130_("XXX").m_126132_("has_comb", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.BEE_COMBS)).m_176498_(helper);
        ItemLike propolis = (ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL);
        ShapedRecipeBuilder.m_126116_(CoreItems.BITUMINOUS_PEAT).m_206416_(Character.valueOf('#'), ForestryTags.Items.DUSTS_ASH).m_126127_(Character.valueOf('X'), CoreItems.PEAT).m_126127_(Character.valueOf('Y'), propolis).m_126130_(" # ").m_126130_("XYX").m_126130_(" # ").m_126132_("has_propolis", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)propolis)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.FRAME_IMPREGNATED).m_126127_(Character.valueOf('#'), CoreItems.STICK_IMPREGNATED).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126130_("###").m_126130_("#S#").m_126130_("###").m_126132_("has_impregnated_stick", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STICK_IMPREGNATED)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.FRAME_UNTREATED).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126130_("###").m_126130_("#S#").m_126130_("###").m_126132_("has_impregnated_stick", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STICK_IMPREGNATED)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.PULSATING_MESH))).m_126127_(Character.valueOf('#'), (ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.PULSATING)).m_126130_("# #").m_126130_(" # ").m_126130_("# #").m_126132_("has_pulsating_propolis", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)((ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.PULSATING)))).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.SCOOP).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('X'), ItemTags.f_13167_).m_126130_("#X#").m_126130_("###").m_126130_(" # ").m_126132_("has_wool", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)ItemTags.f_13167_)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42518_).m_126127_(Character.valueOf('#'), propolis).m_126127_(Character.valueOf('X'), (ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)).m_126130_("#X#").m_126130_("#X#").m_126130_("#X#").m_126132_("has_propolis", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)propolis)).m_126140_(helper, ForestryConstants.forestry("slime_from_propolis"));
        ShapedRecipeBuilder.m_126116_(ApicultureItems.SMOKER).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42409_).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_126130_("LS#").m_126130_("LF#").m_126130_("###").m_126132_("has_tin", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_TIN)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42546_).m_126127_(Character.valueOf('#'), (ItemLike)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY)).m_126127_(Character.valueOf('X'), ApicultureItems.HONEYDEW).m_126127_(Character.valueOf('Y'), (ItemLike)Items.f_42575_).m_126130_("#X#").m_126130_("#Y#").m_126130_("#X#").m_126132_("has_melon", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42575_)).m_126140_(helper, ForestryConstants.forestry("glistering_melon_slice"));
        FeatureItem<ItemForestry> beesWax = CoreItems.BEESWAX;
        ShapedRecipeBuilder.m_126118_((ItemLike)Items.f_42000_, (int)3).m_126127_(Character.valueOf('#'), beesWax).m_206416_(Character.valueOf('Y'), Tags.Items.RODS_WOODEN).m_126130_(" # ").m_126130_(" # ").m_126130_(" Y ").m_126132_("has_wax", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(beesWax)).m_126140_(helper, ForestryConstants.forestry("torch_from_wax"));
        ShapedRecipeBuilder.m_126116_(ApicultureItems.WAX_CAST).m_126127_(Character.valueOf('#'), beesWax).m_126130_("###").m_126130_("# #").m_126130_("###").m_126132_("has_wax", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(beesWax)).m_176498_(helper);
    }

    private void registerCombRecipes(Consumer<FinishedRecipe> helper) {
        for (EnumHoneyComb honeyComb : EnumHoneyComb.VALUES) {
            ItemLike comb = (ItemLike)ApicultureItems.BEE_COMBS.get(honeyComb);
            Object combBlock = ((FeatureBlock)ApicultureBlocks.BEE_COMB.get(honeyComb)).block();
            ShapedRecipeBuilder.m_126116_(combBlock).m_126127_(Character.valueOf('#'), comb).m_126130_("##").m_126130_("##").m_126132_("has_comb", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)comb)).m_126145_("combs").m_176498_(helper);
        }
    }

    private void registerArboricultureRecipes(Consumer<FinishedRecipe> helper) {
        this.registerWoodRecipes(helper);
        ShapedRecipeBuilder.m_126116_(ArboricultureItems.GRAFTER).m_206416_(Character.valueOf('B'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126130_("  B").m_126130_(" # ").m_126130_("#  ").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.ARBORIST_CHEST))).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), ItemTags.f_13180_).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_(" # ").m_126130_("XYX").m_126130_("XXX").m_126132_("has_sapling", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)ItemTags.f_13180_)).m_176498_(helper);
    }

    private void registerWoodRecipes(Consumer<FinishedRecipe> helper) {
        WoodAccess woodAccess = WoodAccess.INSTANCE;
        List<IWoodType> woodTypes = woodAccess.getRegisteredWoodTypes();
        for (IWoodType woodType : woodTypes) {
            Block planks = woodAccess.getBlock(woodType, WoodBlockKind.PLANKS, false).m_60734_();
            Block fireproofPlanks = woodAccess.getBlock(woodType, WoodBlockKind.PLANKS, true).m_60734_();
            Block log = woodAccess.getBlock(woodType, WoodBlockKind.LOG, false).m_60734_();
            Block wood = woodAccess.getBlock(woodType, WoodBlockKind.WOOD, false).m_60734_();
            Block fireproofLog = woodAccess.getBlock(woodType, WoodBlockKind.LOG, true).m_60734_();
            Block door = woodAccess.getBlock(woodType, WoodBlockKind.DOOR, false).m_60734_();
            Block fence = woodAccess.getBlock(woodType, WoodBlockKind.FENCE, false).m_60734_();
            Block fireproofFence = woodAccess.getBlock(woodType, WoodBlockKind.FENCE, true).m_60734_();
            Block fencegate = woodAccess.getBlock(woodType, WoodBlockKind.FENCE_GATE, false).m_60734_();
            Block fireproofFencegate = woodAccess.getBlock(woodType, WoodBlockKind.FENCE_GATE, true).m_60734_();
            Block slab = woodAccess.getBlock(woodType, WoodBlockKind.SLAB, false).m_60734_();
            Block fireproofSlab = woodAccess.getBlock(woodType, WoodBlockKind.SLAB, true).m_60734_();
            Block stairs = woodAccess.getBlock(woodType, WoodBlockKind.STAIRS, false).m_60734_();
            Block fireproofStairs = woodAccess.getBlock(woodType, WoodBlockKind.STAIRS, true).m_60734_();
            if (woodType instanceof ForestryWoodType) {
                ShapelessRecipeBuilder.m_126191_((ItemLike)planks, (int)4).m_126209_((ItemLike)log).m_126132_("has_log", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)log)).m_126145_("planks").m_176498_(helper);
                ShapedRecipeBuilder.m_126118_((ItemLike)fence, (int)3).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('W'), (ItemLike)planks).m_126130_("W#W").m_126130_("W#W").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)planks)).m_126145_("wooden_fence").m_176498_(helper);
                ShapedRecipeBuilder.m_126116_((ItemLike)fencegate).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('W'), (ItemLike)planks).m_126130_("#W#").m_126130_("#W#").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)planks)).m_126145_("wooden_fence_gate").m_176498_(helper);
                ShapedRecipeBuilder.m_126118_((ItemLike)slab, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126130_("###").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)planks)).m_126145_("wooden_slab").m_176498_(helper);
                ShapedRecipeBuilder.m_126118_((ItemLike)stairs, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)planks)).m_126145_("wooden_stairs").m_176498_(helper);
                ShapedRecipeBuilder.m_126118_((ItemLike)wood, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)log).m_126130_("##").m_126130_("##").m_126132_("has_log", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)log)).m_126145_("bark").m_176498_(helper);
            }
            ShapedRecipeBuilder.m_126118_((ItemLike)door, (int)3).m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{planks, fireproofPlanks})).m_126130_("##").m_126130_("##").m_126130_("##").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)planks)).m_126145_("wooden_door").m_176498_(helper);
            ShapelessRecipeBuilder.m_126191_((ItemLike)fireproofPlanks, (int)4).m_126209_((ItemLike)fireproofLog).m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)fireproofPlanks)).m_126145_("planks").m_176498_(helper);
            ShapedRecipeBuilder.m_126118_((ItemLike)fireproofFence, (int)3).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('W'), (ItemLike)fireproofPlanks).m_126130_("W#W").m_126130_("W#W").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)fireproofPlanks)).m_126145_("wooden_fence").m_176498_(helper);
            ShapedRecipeBuilder.m_126116_((ItemLike)fireproofFencegate).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('W'), (ItemLike)fireproofPlanks).m_126130_("#W#").m_126130_("#W#").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)fireproofPlanks)).m_126145_("wooden_fence_gate").m_176498_(helper);
            ShapedRecipeBuilder.m_126118_((ItemLike)fireproofSlab, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)fireproofPlanks).m_126130_("###").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)fireproofPlanks)).m_126145_("wooden_slab").m_176498_(helper);
            ShapedRecipeBuilder.m_126118_((ItemLike)fireproofStairs, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)fireproofPlanks).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126132_("has_planks", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)fireproofPlanks)).m_126145_("wooden_stairs").m_176498_(helper);
        }
    }

    private void registerFoodRecipes(Consumer<FinishedRecipe> helper) {
        ItemLike waxCapsule = (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAPSULE);
        ItemLike honeyDrop = (ItemLike)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.AMBROSIA).m_126127_(Character.valueOf('#'), ApicultureItems.HONEYDEW).m_126127_(Character.valueOf('X'), ApicultureItems.ROYAL_JELLY).m_126127_(Character.valueOf('Y'), waxCapsule).m_126130_("#Y#").m_126130_("XXX").m_126130_("###").m_126132_("has royal_jelly", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(ApicultureItems.ROYAL_JELLY)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.HONEY_POT).m_126127_(Character.valueOf('#'), honeyDrop).m_126127_(Character.valueOf('X'), waxCapsule).m_126130_("# #").m_126130_(" X ").m_126130_("# #").m_126132_("has_drop", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)honeyDrop)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(ApicultureItems.HONEYED_SLICE).m_126127_(Character.valueOf('#'), honeyDrop).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42406_).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126132_("has_drop", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)honeyDrop)).m_176498_(helper);
    }

    private void registerBackpackRecipes(Consumer<FinishedRecipe> helper) {
        ShapedRecipeBuilder.m_126116_(BackpackItems.ADVENTURER_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_206416_(Character.valueOf('V'), Tags.Items.BONES).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_bone", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)Tags.Items.BONES)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(BackpackItems.BUILDER_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_126127_(Character.valueOf('V'), (ItemLike)Items.f_42461_).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_clay", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42461_)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(BackpackItems.DIGGER_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_206416_(Character.valueOf('V'), Tags.Items.STONE).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_stone", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)Tags.Items.STONE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(BackpackItems.FORESTER_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_206416_(Character.valueOf('V'), ItemTags.f_13182_).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_log", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)ItemTags.f_13182_)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(BackpackItems.HUNTER_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_206416_(Character.valueOf('V'), Tags.Items.FEATHERS).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_feather", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)Tags.Items.FEATHERS)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(BackpackItems.MINER_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_206416_(Character.valueOf('V'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_iron", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_176498_(helper);
        ItemLike beeChest = (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.APIARIST_CHEST);
        ShapedRecipeBuilder.m_126116_(BackpackItems.APIARIST_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_206416_(Character.valueOf('V'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_126127_(Character.valueOf('Y'), beeChest).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_bee_chest", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)beeChest)).m_176498_(helper);
        ItemLike butterflyChest = (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.LEPIDOPTERIST_CHEST);
        ShapedRecipeBuilder.m_126116_(BackpackItems.LEPIDOPTERIST_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_126127_(Character.valueOf('V'), butterflyChest).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_butterfly_chest", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)butterflyChest)).m_176498_(helper);
        ItemLike treeChest = (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.ARBORIST_CHEST);
        ShapedRecipeBuilder.m_126116_(BackpackItems.ARBORIST_BACKPACK).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_126127_(Character.valueOf('V'), treeChest).m_206416_(Character.valueOf('X'), Tags.Items.STRING).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("VYV").m_126130_("X#X").m_126132_("has_butterfly_chest", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)treeChest)).m_176498_(helper);
    }

    private void registerCharcoalRecipes(Consumer<FinishedRecipe> helper) {
        ShapedRecipeBuilder.m_126116_((ItemLike)CharcoalBlocks.CHARCOAL.block()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42414_).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_charcoal", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42414_)).m_176498_(helper);
        ShapelessRecipeBuilder.m_126191_((ItemLike)Items.f_42414_, (int)9).m_206419_(ForestryTags.Items.CHARCOAL_BLOCK).m_126132_("has_charcoal_block", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.CHARCOAL_BLOCK)).m_126140_(helper, ForestryConstants.forestry("charcoal_from_block"));
        ShapedRecipeBuilder.m_126116_((ItemLike)CharcoalBlocks.WOOD_PILE.block()).m_206416_(Character.valueOf('L'), ItemTags.f_13182_).m_126130_(" L ").m_126130_("L L").m_126130_(" L ").m_126132_("has_log", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)ItemTags.f_13182_)).m_176498_(helper);
        ShapelessRecipeBuilder.m_126189_((ItemLike)CharcoalBlocks.WOOD_PILE_DECORATIVE.block()).m_126209_((ItemLike)CharcoalBlocks.WOOD_PILE.block()).m_126132_("was_wood_pile", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)CharcoalBlocks.WOOD_PILE.block())).m_176498_(helper);
        ShapelessRecipeBuilder.m_126189_((ItemLike)CharcoalBlocks.WOOD_PILE.block()).m_126209_((ItemLike)CharcoalBlocks.WOOD_PILE_DECORATIVE.block()).m_126132_("has_decorative", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)CharcoalBlocks.WOOD_PILE_DECORATIVE.block())).m_126140_(helper, ForestryConstants.forestry("wood_pile_from_decorative"));
    }

    private void registerCoreRecipes(Consumer<FinishedRecipe> helper) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(ForestryTags.Items.ORES_APATITE), CoreItems.APATITE, (float)0.5f, (int)200).m_126132_("has_apatite_ore", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.ORES_APATITE)).m_126140_(helper, ForestryConstants.forestry("apatite_from_smelting_apatite_ore"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(ForestryTags.Items.ORES_APATITE), CoreItems.APATITE, (float)0.5f, (int)100).m_126132_("has_apatite_ore", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.ORES_APATITE)).m_126140_(helper, ForestryConstants.forestry("apatite_from_blasting_apatite_ore"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(ForestryTags.Items.ORES_TIN), CoreItems.INGOT_TIN, (float)0.5f, (int)200).m_126132_("has_tin_ore", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.ORES_TIN)).m_126140_(helper, ForestryConstants.forestry("tin_ingot_from_smelting_tin_ore"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(ForestryTags.Items.ORES_TIN), CoreItems.INGOT_TIN, (float)0.5f, (int)100).m_126132_("has_tin_ore", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.ORES_TIN)).m_126140_(helper, ForestryConstants.forestry("tin_ingot_from_blasting_tin_ore"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(ForestryTags.Items.RAW_MATERIALS_TIN), CoreItems.INGOT_TIN, (float)0.5f, (int)200).m_126132_("has_raw_tin", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.RAW_MATERIALS_TIN)).m_126140_(helper, ForestryConstants.forestry("tin_ingot_from_smelting_raw_tin"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(ForestryTags.Items.RAW_MATERIALS_TIN), CoreItems.INGOT_TIN, (float)0.5f, (int)100).m_126132_("has_raw_tin", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.RAW_MATERIALS_TIN)).m_126140_(helper, ForestryConstants.forestry("tin_ingot_from_blasting_raw_tin"));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PEAT}), CoreItems.ASH, (float)0.0f, (int)200).m_126132_("has_peat", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.PEAT)).m_126140_(helper, ForestryConstants.forestry("ash_from_peat_blasting"));
        ShapelessRecipeBuilder.m_126191_(CoreItems.RAW_TIN, (int)9).m_126209_(CoreBlocks.RAW_TIN_BLOCK).m_126132_(ForestryRecipeProvider.m_176602_(CoreBlocks.RAW_TIN_BLOCK), (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreBlocks.RAW_TIN_BLOCK)).m_126140_(helper, ForestryConstants.forestry("raw_tin"));
        ShapedRecipeBuilder.m_126116_(CoreBlocks.RAW_TIN_BLOCK).m_126127_(Character.valueOf('#'), CoreItems.RAW_TIN).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_(ForestryRecipeProvider.m_176602_(CoreItems.RAW_TIN), (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.RAW_TIN)).m_126140_(helper, ForestryConstants.forestry("raw_tin_block"));
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)CoreBlocks.BASE.get(BlockTypeCoreTesr.ANALYZER)).block()).m_126127_(Character.valueOf('T'), CoreItems.PORTABLE_ALYZER).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("XTX").m_126130_(" Y ").m_126130_("X X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.APATITE)).block()).m_206416_(Character.valueOf('#'), ForestryTags.Items.GEMS_APATITE).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_apatite", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.GEMS_APATITE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.BRONZE)).block()).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.TIN)).block()).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_apatite", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_TIN)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(CoreItems.BRONZE_PICKAXE).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_126130_("###").m_126130_(" X ").m_126130_(" X ").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(CoreItems.BRONZE_SHOVEL).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_126130_(" # ").m_126130_(" X ").m_126130_(" X ").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE)).m_176498_(helper);
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition("forge", "gears/stone"))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_(CoreItems.GEAR_BRONZE).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEARS_STONE).m_126130_(" # ").m_126130_("#X#").m_126130_(" # ").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE))).m_176498_(arg_0)).addCondition((ICondition)new TagEmptyCondition("forge", "gears/stone")).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_(CoreItems.GEAR_BRONZE).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_151052_).m_126130_(" # ").m_126130_("#X#").m_126130_(" # ").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE))).m_176498_(arg_0)).build(helper, ForestryConstants.forestry("gear_bronze"));
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition("forge", "gears/stone"))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_(CoreItems.GEAR_COPPER).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_151052_).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEARS_STONE).m_126130_(" # ").m_126130_("#X#").m_126130_(" # ").m_126132_("has_copper", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_151052_))).m_176498_(arg_0)).addCondition((ICondition)new TagEmptyCondition("forge", "gears/stone")).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_(CoreItems.GEAR_COPPER).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_151052_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_151052_).m_126130_(" # ").m_126130_("#X#").m_126130_(" # ").m_126132_("has_copper", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_151052_))).m_176498_(arg_0)).build(helper, ForestryConstants.forestry("gear_copper"));
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition("forge", "gears/stone"))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_(CoreItems.GEAR_TIN).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEARS_STONE).m_126130_(" # ").m_126130_("#X#").m_126130_(" # ").m_126132_("has_tin", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_TIN))).m_176498_(arg_0)).addCondition((ICondition)new TagEmptyCondition("forge", "gears/stone")).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_(CoreItems.GEAR_TIN).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_151052_).m_126130_(" # ").m_126130_("#X#").m_126130_(" # ").m_126132_("has_tin", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_TIN))).m_176498_(arg_0)).build(helper, ForestryConstants.forestry("gear_tin"));
        ShapelessRecipeBuilder.m_126191_(CoreItems.INGOT_BRONZE, (int)4).m_206419_(ForestryTags.Items.INGOTS_TIN).m_126209_((ItemLike)Items.f_151052_).m_126209_((ItemLike)Items.f_151052_).m_126209_((ItemLike)Items.f_151052_).m_126132_("has_tin", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_TIN)).m_126140_(helper, ForestryConstants.forestry("ingot_bronze_alloying"));
        ShapelessRecipeBuilder.m_126191_(CoreItems.APATITE, (int)9).m_206419_(ForestryTags.Items.STORAGE_BLOCKS_APATITE).m_126132_("has_block", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.STORAGE_BLOCKS_APATITE)).m_176498_(helper);
        ShapelessRecipeBuilder.m_126191_(CoreItems.INGOT_BRONZE, (int)9).m_206419_(ForestryTags.Items.STORAGE_BLOCKS_BRONZE).m_126132_("has_block", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.STORAGE_BLOCKS_BRONZE)).m_176498_(helper);
        ShapelessRecipeBuilder.m_126191_(CoreItems.INGOT_TIN, (int)9).m_206419_(ForestryTags.Items.STORAGE_BLOCKS_TIN).m_126132_("has_block", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.STORAGE_BLOCKS_TIN)).m_176498_(helper);
        ShapelessRecipeBuilder.m_126189_(CoreItems.KIT_PICKAXE).m_126209_(CoreItems.BRONZE_PICKAXE).m_126209_(CoreItems.CARTON).m_126132_("has_pickaxe", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.BRONZE_PICKAXE)).m_176498_(helper);
        ShapelessRecipeBuilder.m_126189_(CoreItems.KIT_SHOVEL).m_126209_(CoreItems.BRONZE_SHOVEL).m_126209_(CoreItems.CARTON).m_126132_("has_shovel", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.BRONZE_SHOVEL)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(CoreItems.SPECTACLES).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('Y'), Tags.Items.GLASS_PANES).m_126130_(" X ").m_126130_("Y Y").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(CoreItems.PIPETTE).m_206416_(Character.valueOf('#'), ItemTags.f_13167_).m_206416_(Character.valueOf('X'), Tags.Items.GLASS_PANES).m_126130_("  #").m_126130_(" X ").m_126130_("X  ").m_126132_("has_wool", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)ItemTags.f_13167_)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(CoreItems.PORTABLE_ALYZER).m_206416_(Character.valueOf('#'), Tags.Items.GLASS_PANES).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).m_126130_("X#X").m_126130_("X#X").m_126130_("RDR").m_126132_("has_diamond", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42401_).m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)).m_126130_(" # ").m_126130_(" # ").m_126130_(" # ").m_126132_("has_wisp", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)))).m_126140_(helper, ForestryConstants.forestry("string_from_wisp"));
        ShapedRecipeBuilder.m_126116_(CoreItems.STURDY_CASING).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126130_("###").m_126130_("# #").m_126130_("###").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126118_((ItemLike)Items.f_41863_, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)).m_126130_("# #").m_126130_(" # ").m_126130_("# #").m_126132_("has_wisp", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)))).m_126140_(helper, ForestryConstants.forestry("cobweb_from_wisp"));
        ShapedRecipeBuilder.m_126116_(CoreItems.WRENCH).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126130_("# #").m_126130_(" # ").m_126130_(" # ").m_126132_("has_bronze", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_BRONZE)).m_176498_(helper);
        ShapedRecipeBuilder.m_126118_(CoreItems.COMPOST, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50493_).m_206416_(Character.valueOf('X'), Tags.Items.CROPS_WHEAT).m_126130_(" X ").m_126130_("X#X").m_126130_(" X ").m_126132_("has_wheat", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)Tags.Items.CROPS_WHEAT)).m_126140_(helper, ForestryConstants.forestry("compost_wheat"));
        ShapedRecipeBuilder.m_126118_(CoreItems.COMPOST, (int)1).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50493_).m_206416_(Character.valueOf('X'), ForestryTags.Items.DUSTS_ASH).m_126130_(" X ").m_126130_("X#X").m_126130_(" X ").m_126132_("has_ash", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.DUSTS_ASH)).m_126140_(helper, ForestryConstants.forestry("compost_ash"));
        ShapedRecipeBuilder.m_126118_(CoreItems.FERTILIZER_COMPOUND, (int)8).m_206416_(Character.valueOf('#'), ItemTags.f_13137_).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEMS_APATITE).m_126130_(" # ").m_126130_(" X ").m_126130_(" # ").m_126132_("has_apatite", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.GEMS_APATITE)).m_126140_(helper, ForestryConstants.forestry("fertilizer_apatite"));
        ShapedRecipeBuilder.m_126118_(CoreItems.FERTILIZER_COMPOUND, (int)16).m_206416_(Character.valueOf('#'), ForestryTags.Items.DUSTS_ASH).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEMS_APATITE).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126132_("has_apatite", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.GEMS_APATITE)).m_126140_(helper, ForestryConstants.forestry("fertilizer_ash"));
        ShapedRecipeBuilder.m_126118_(CoreBlocks.HUMUS, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50493_).m_126127_(Character.valueOf('X'), CoreItems.COMPOST).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126132_("has_compost", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.COMPOST)).m_126140_(helper, ForestryConstants.forestry("humus_compost"));
        ShapedRecipeBuilder.m_126118_(CoreBlocks.HUMUS, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50493_).m_126127_(Character.valueOf('X'), CoreItems.FERTILIZER_COMPOUND).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126132_("has_fertilizer", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.FERTILIZER_COMPOUND)).m_126140_(helper, ForestryConstants.forestry("humus_fertilizer"));
        TriConsumer bogRecipe = (amount, container, name) -> ShapedRecipeBuilder.m_126118_(CoreBlocks.BOG_EARTH, (int)amount).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50493_).m_126124_(Character.valueOf('X'), (Ingredient)StrictNBTIngredient.of((ItemStack)container)).m_206416_(Character.valueOf('Y'), ItemTags.f_13137_).m_126130_("#Y#").m_126130_("YXY").m_126130_("#Y#").m_126132_("has_sand", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)ItemTags.f_13137_)).m_126140_(helper, ForestryConstants.forestry("bog_earth_" + name));
        bogRecipe.accept((Object)6, (Object)new ItemStack((ItemLike)Items.f_42447_), (Object)"bucket");
        ItemStack canWater = ForestryRecipeProvider.getContainer(EnumContainerType.CAN, (Fluid)Fluids.f_76193_);
        ItemStack waxCapsuleWater = ForestryRecipeProvider.getContainer(EnumContainerType.CAPSULE, (Fluid)Fluids.f_76193_);
        ItemStack refractoryWater = ForestryRecipeProvider.getContainer(EnumContainerType.REFRACTORY, (Fluid)Fluids.f_76193_);
        bogRecipe.accept((Object)8, (Object)canWater, (Object)"can");
        bogRecipe.accept((Object)8, (Object)waxCapsuleWater, (Object)"wax_capsule");
        bogRecipe.accept((Object)8, (Object)refractoryWater, (Object)"refractory");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)), (int)12).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_126130_(" # ").m_126130_("# #").m_126132_("has_tin", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.INGOTS_TIN)).m_126140_(helper, ForestryConstants.forestry("can"));
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAPSULE)), (int)4).m_126127_(Character.valueOf('#'), CoreItems.BEESWAX).m_126130_(" # ").m_126130_("# #").m_126132_("has_beeswax", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.BEESWAX)).m_126140_(helper, ForestryConstants.forestry("capsule"));
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.REFRACTORY)), (int)4).m_126127_(Character.valueOf('#'), CoreItems.REFRACTORY_WAX).m_126130_(" # ").m_126130_("# #").m_126132_("has_refractory_wax", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.REFRACTORY_WAX)).m_126140_(helper, ForestryConstants.forestry("refractory_capsule"));
    }

    private void registerBookRecipes(Consumer<FinishedRecipe> helper) {
        ShapelessRecipeBuilder.m_126189_(CoreItems.FORESTERS_MANUAL).m_126209_((ItemLike)Items.f_42517_).m_126209_((ItemLike)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY)).m_126132_("has_book", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_126140_(helper, ForestryConstants.forestry("foresters_manual_honeydrop"));
        ShapelessRecipeBuilder.m_126189_(CoreItems.FORESTERS_MANUAL).m_126209_((ItemLike)Items.f_42517_).m_206419_(ItemTags.f_13180_).m_126132_("has_book", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_126140_(helper, ForestryConstants.forestry("foresters_manual_sapling"));
        ShapelessRecipeBuilder.m_126189_(CoreItems.FORESTERS_MANUAL).m_126209_((ItemLike)Items.f_42517_).m_126209_(LepidopterologyItems.BUTTERFLY_GE).m_126132_("has_book", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_126140_(helper, ForestryConstants.forestry("foresters_manual_butterfly"));
    }

    private EnumElectronTube getElectronTube(BlockTypePlanter planter) {
        return switch (planter) {
            default -> throw new IncompatibleClassChangeError();
            case BlockTypePlanter.ARBORETUM -> EnumElectronTube.GOLD;
            case BlockTypePlanter.FARM_CROPS -> EnumElectronTube.BRONZE;
            case BlockTypePlanter.PEAT_POG -> EnumElectronTube.OBSIDIAN;
            case BlockTypePlanter.FARM_MUSHROOM -> EnumElectronTube.APATITE;
            case BlockTypePlanter.FARM_GOURD -> EnumElectronTube.LAPIS;
            case BlockTypePlanter.FARM_NETHER -> EnumElectronTube.BLAZE;
            case BlockTypePlanter.FARM_ENDER -> EnumElectronTube.ENDER;
        };
    }

    private void registerCultivationRecipes(Consumer<FinishedRecipe> helper) {
        for (BlockTypePlanter planter : BlockTypePlanter.values()) {
            Object managed = ((FeatureBlock)CultivationBlocks.PLANTER.get(planter, BlockPlanter.Mode.MANAGED)).block();
            Object manual = ((FeatureBlock)CultivationBlocks.PLANTER.get(planter, BlockPlanter.Mode.MANUAL)).block();
            ShapedRecipeBuilder.m_126116_(managed).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('T'), (ItemLike)CoreItems.ELECTRON_TUBES.get(this.getElectronTube(planter))).m_126127_(Character.valueOf('C'), CoreItems.FLEXIBLE_CASING).m_126127_(Character.valueOf('B'), (ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.BASIC)).m_126130_("GTG").m_126130_("TCT").m_126130_("GBG").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.FLEXIBLE_CASING)).m_176498_(helper);
            ShapelessRecipeBuilder.m_126189_(manual).m_126209_(managed).m_126132_("has_managed", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(managed)).m_176498_(helper);
            ShapelessRecipeBuilder.m_126189_(managed).m_126209_(manual).m_126132_("has_manual", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(manual)).m_126140_(helper, ForestryConstants.forestry(ModUtil.getRegistryName(managed).m_135815_() + "_from_manual"));
        }
    }

    private void registerFactoryRecipes(Consumer<FinishedRecipe> helper) {
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.BOTTLER)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_126127_(Character.valueOf('X'), (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("#Y#").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CARPENTER)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("XYX").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CENTRIFUGE)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_151052_).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("XYX").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.FABRICATOR)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_206416_(Character.valueOf('Z'), Tags.Items.CHESTS_WOODEN).m_126130_("X#X").m_126130_("#Y#").m_126130_("XZX").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.FERMENTER)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEARS_BRONZE).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("#Y#").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.MOISTENER)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEARS_COPPER).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("#Y#").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.RAINMAKER)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEARS_TIN).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("#Y#").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.RAINTANK)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("XYX").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.SQUEEZER)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("XYX").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.STILL)).block()).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_206416_(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_("X#X").m_126130_("#Y#").m_126130_("X#X").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
    }

    private void registerFarmingRecipes(Consumer<FinishedRecipe> helper) {
        for (EnumFarmMaterial material : EnumFarmMaterial.values()) {
            Item base = material.getBase().m_5456_();
            ShapedRecipeBuilder.m_126116_(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.PLAIN, material)).block()).m_126127_(Character.valueOf('#'), (ItemLike)base).m_126127_(Character.valueOf('C'), (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.TIN)).m_206416_(Character.valueOf('W'), ItemTags.f_13175_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_151052_).m_126130_("I#I").m_126130_("WCW").m_126132_("has_copper", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_151052_)).m_176498_(helper);
            ShapedRecipeBuilder.m_126116_(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.GEARBOX, material)).block()).m_126127_(Character.valueOf('#'), (ItemLike)base).m_206416_(Character.valueOf('T'), ForestryTags.Items.GEARS_TIN).m_126130_(" # ").m_126130_("TTT").m_126132_("has_tin_gear", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.GEARS_TIN)).m_176498_(helper);
            ShapedRecipeBuilder.m_126116_(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.HATCH, material)).block()).m_126127_(Character.valueOf('#'), (ItemLike)base).m_206416_(Character.valueOf('T'), ForestryTags.Items.GEARS_TIN).m_206416_(Character.valueOf('D'), ItemTags.f_13178_).m_126130_(" # ").m_126130_("TDT").m_126132_("has_tin_gear", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.GEARS_TIN)).m_176498_(helper);
            ShapedRecipeBuilder.m_126116_(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.VALVE, material)).block()).m_126127_(Character.valueOf('#'), (ItemLike)base).m_206416_(Character.valueOf('T'), ForestryTags.Items.GEARS_TIN).m_206416_(Character.valueOf('X'), Tags.Items.GLASS).m_126130_(" # ").m_126130_("XTX").m_126132_("has_tin_gear", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.GEARS_TIN)).m_176498_(helper);
            ShapedRecipeBuilder.m_126116_(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.CONTROL, material)).block()).m_126127_(Character.valueOf('#'), (ItemLike)base).m_126127_(Character.valueOf('T'), (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD)).m_206416_(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).m_126130_(" # ").m_126130_("XTX").m_126132_("has_tin_gear", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_(ForestryTags.Items.GEARS_TIN)).m_176498_(helper);
        }
    }

    private void registerFluidsRecipes(Consumer<FinishedRecipe> helper) {
        for (EnumContainerType containerType : EnumContainerType.values()) {
            ItemStack filled = ForestryRecipeProvider.getContainer(containerType, (Fluid)ForgeMod.MILK.get());
            ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42502_).m_126124_(Character.valueOf('A'), (Ingredient)StrictNBTIngredient.of((ItemStack)filled)).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42405_).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42521_).m_126130_("AAA").m_126130_("BEB").m_126130_("CCC").m_126132_("has_wheat", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42405_)).m_126140_(helper, ForestryConstants.forestry("cake_" + containerType.m_7912_()));
        }
    }

    private void registerLepidopterologyRecipes(Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.LEPIDOPTERIST_CHEST))).m_206416_(Character.valueOf('#'), Tags.Items.GLASS).m_126127_(Character.valueOf('X'), LepidopterologyItems.BUTTERFLY_GE).m_206416_(Character.valueOf('Y'), Tags.Items.CHESTS_WOODEN).m_126130_(" # ").m_126130_("XYX").m_126130_("XXX").m_126132_("has_butterfly", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(LepidopterologyItems.BUTTERFLY_GE)).m_176498_(output);
        SpecialRecipeBuilder.m_126357_((SimpleRecipeSerializer)((SimpleRecipeSerializer)LepidopterologyRecipes.MATING_SERIALIZER.get())).m_126359_(output, "butterfly_mating");
    }

    private void registerMailRecipes(Consumer<FinishedRecipe> helper) {
        ShapelessRecipeBuilder.m_126189_(MailItems.CATALOGUE).m_126209_((ItemLike)Items.f_42517_).m_206419_(ForestryTags.Items.STAMPS).m_126132_("has_book", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_176498_(helper);
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)MailItems.LETTERS.get(ItemLetter.Size.EMPTY, ItemLetter.State.FRESH))).m_126209_((ItemLike)Items.f_42516_).m_126184_(Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_(ForestryTags.Items.PROPOLIS), Ingredient.m_204132_((TagKey)Tags.Items.SLIMEBALLS)}))).m_126132_("has_paper", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42516_)).m_176498_(helper);
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)MailBlocks.BASE.get(BlockTypeMail.MAILBOX)).block()).m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('X'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126130_(" # ").m_126130_("#Y#").m_126130_("XXX").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        Item[] emptiedLetter = (Item[])MailItems.LETTERS.getRowFeatures(ItemLetter.Size.EMPTY).stream().map(FeatureItem::item).toArray(Item[]::new);
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42516_).m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])emptiedLetter)).m_126130_(" # ").m_126130_(" # ").m_126130_(" # ").m_126132_("has_paper", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42516_)).m_126140_(helper, ForestryConstants.forestry("paper_from_letters"));
        ShapedRecipeBuilder.m_126116_(((FeatureBlock)MailBlocks.BASE.get(BlockTypeMail.TRADE_STATION)).block()).m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BRONZE)).m_206416_(Character.valueOf('X'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING).m_126127_(Character.valueOf('Z'), (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.IRON)).m_126124_(Character.valueOf('W'), (Ingredient)StrictNBTIngredient.of((ItemStack)ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]))).m_126130_("Z#Z").m_126130_("#Y#").m_126130_("XWX").m_126132_("has_casing", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_(CoreItems.STURDY_CASING)).m_176498_(helper);
        Ingredient glue = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_(ForestryTags.Items.DROP_HONEY), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_})}));
        for (EnumStampDefinition stampDefinition : EnumStampDefinition.VALUES) {
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)MailItems.STAMPS.get(stampDefinition)), (int)9).m_126124_(Character.valueOf('X'), stampDefinition.getCraftingIngredient()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42516_).m_126124_(Character.valueOf('Z'), glue).m_126130_("XXX").m_126130_("###").m_126130_("ZZZ").m_126132_("has_paper", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42516_)).m_176498_(helper);
        }
    }

    private void registerSortingRecipes(Consumer<FinishedRecipe> helper) {
        Ingredient ing = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{LepidopterologyItems.CATERPILLAR_GE, (ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL)}), Ingredient.m_204132_(ForestryTags.Items.FORESTRY_FRUITS)}));
        ShapedRecipeBuilder.m_126118_((ItemLike)SortingBlocks.FILTER.block(), (int)2).m_206416_(Character.valueOf('B'), ForestryTags.Items.GEARS_BRONZE).m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).m_126124_(Character.valueOf('F'), ing).m_206416_(Character.valueOf('W'), ItemTags.f_13168_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("WDW").m_126130_("FGF").m_126130_("BDB").m_126132_("has_diamond", (CriterionTriggerInstance)ForestryRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_176498_(helper);
    }

    private void registerWorktableRecipes(Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126118_((ItemLike)WorktableBlocks.WORKTABLE.block(), (int)1).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_206416_(Character.valueOf('T'), ForestryTags.Items.CRAFTING_TABLES).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_126130_("B").m_126130_("T").m_126130_("C").m_126132_("has_book", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_176498_(output);
    }

    private void registerEnergyRecipes(Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)EnergyBlocks.ENGINES.get(EngineBlockType.CLOCKWORK))).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_206416_(Character.valueOf('I'), Tags.Items.GLASS).m_206416_(Character.valueOf('Q'), ForestryTags.Items.GEARS_COPPER).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42524_).m_126130_("PPP").m_126130_(" I ").m_126130_("QDC").m_126132_("has_piston", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_41869_)).m_176498_(output);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)EnergyBlocks.ENGINES.get(EngineBlockType.BIOGAS))).m_206416_(Character.valueOf('P'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('I'), Tags.Items.GLASS).m_206416_(Character.valueOf('Q'), ForestryTags.Items.GEARS_BRONZE).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_41869_).m_126130_("PPP").m_126130_(" I ").m_126130_("QDQ").m_126132_("has_piston", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_41869_)).m_176498_(output);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)EnergyBlocks.ENGINES.get(EngineBlockType.PEAT))).m_206416_(Character.valueOf('P'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('I'), Tags.Items.GLASS).m_206416_(Character.valueOf('Q'), ForestryTags.Items.GEARS_COPPER).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_41869_).m_126130_("PPP").m_126130_(" I ").m_126130_("QDQ").m_126132_("has_piston", (CriterionTriggerInstance)ForestryRecipeProvider.m_125977_((ItemLike)Items.f_41869_)).m_176498_(output);
    }

    protected void m_236367_(CachedOutput cache, JsonObject advancementJson, Path pathIn) {
    }

    public String m_6055_() {
        return "Forestry Recipes";
    }
}

