/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import forestry.api.ForestryConstants;
import forestry.api.ForestryTags;
import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.arboriculture.ForestryTreeSpecies;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.features.ApicultureItems;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.core.features.CoreItems;
import forestry.core.loot.OrganismFunction;
import forestry.core.utils.SpeciesUtil;
import forestry.storage.features.BackpackItems;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableHelper {
    @Nullable
    public static LootTableHelper instance;
    protected final Multimap<ResourceLocation, Entry> entries = LinkedHashMultimap.create();

    public static LootTableHelper getInstance() {
        if (instance == null) {
            instance = new LootTableHelper();
        }
        return instance;
    }

    public LootTableHelper() {
        this.add(BuiltInLootTables.f_78759_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(9))));
        this.add(BuiltInLootTables.f_78759_, "factory", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_factory_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CoreItems.BROKEN_BRONZE_PICKAXE.item()).m_79707_(30)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CoreItems.BROKEN_BRONZE_SHOVEL.item()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CoreItems.KIT_PICKAXE.item()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CoreItems.KIT_SHOVEL.item()).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(50))));
        this.add(BuiltInLootTables.f_78759_, "storage", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_storage_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(BackpackItems.MINER_BACKPACK.item())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(20))));
        this.add(BuiltInLootTables.f_78764_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.STEADFAST).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(6))));
        this.add(BuiltInLootTables.f_78764_, "arboriculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_arboriculture_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.saplingLoot(ForestryTreeSpecies.ACACIA_VANILLA)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(3))));
        this.add(BuiltInLootTables.f_78764_, "factory", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_factory_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CoreItems.ASH.item()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)12.0f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(1))));
        this.add(BuiltInLootTables.f_78741_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.STEADFAST).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.ENDED).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))));
        this.add(BuiltInLootTables.f_78741_, "arboriculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_arboriculture_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ArboricultureItems.GRAFTER.item())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(1))));
        this.add(BuiltInLootTables.f_78688_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.WINTRY).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(7))));
        this.add(BuiltInLootTables.f_78686_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.TROPICAL).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(6))));
        this.add(BuiltInLootTables.f_78686_, "arboriculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_arboriculture_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.saplingLoot(ForestryTreeSpecies.SIPIRI)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(9))));
        this.add(BuiltInLootTables.f_78760_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_(this.beeLoot(ForestryBeeSpecies.SINISTER)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(8))));
        this.add(BuiltInLootTables.f_78742_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(9))));
        this.add(BuiltInLootTables.f_78740_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ApicultureItems.SCOOP.item()))));
        this.add(BuiltInLootTables.f_78763_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(9))));
        this.add(BuiltInLootTables.f_78762_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(9))));
        this.add(BuiltInLootTables.f_78761_, "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.beeLoot(ForestryBeeSpecies.STEADFAST)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.MONASTIC).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(3))));
        this.add(ForestryConstants.forestry("chests/village_naturalist"), "arboriculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_arboriculture_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ArboricultureItems.GRAFTER.item())).m_79076_((LootPoolEntryContainer.Builder)this.saplingLoot(ForestryTreeSpecies.LIME).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)this.saplingLoot(ForestryTreeSpecies.CHERRY).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)this.saplingLoot(ForestryTreeSpecies.LARCH).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_(this.saplingLoot(ForestryTreeSpecies.TEAK)).m_79076_(this.saplingLoot(ForestryTreeSpecies.PADAUK))));
        this.add(ForestryConstants.forestry("chests/village_naturalist"), "apiculture", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("forestry_apiculture_items").m_165133_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(ForestryTags.Items.VILLAGE_COMBS).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ApicultureItems.SCOOP.item()).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(ApicultureItems.SMOKER))).m_79161_(LootPool.m_79043_().name("forestry_apiculture_bees").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.COMMON).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)this.beeLoot(ForestryBeeSpecies.MEADOWS).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(3))));
    }

    private LootPoolSingletonContainer.Builder<?> saplingLoot(ResourceLocation species) {
        return this.saplingLoot(TreeLifeStage.SAPLING, species);
    }

    private LootPoolSingletonContainer.Builder<?> saplingLoot(TreeLifeStage type, ResourceLocation species) {
        return LootItem.m_79579_((ItemLike)this.saplingItem(type)).m_79078_(OrganismFunction.fromDefinition((ISpeciesType)SpeciesUtil.TREE_TYPE.get(), SpeciesUtil.getTreeSpecies(species)));
    }

    private LootPoolSingletonContainer.Builder<?> beeLoot(ResourceLocation species) {
        return this.beeLoot(BeeLifeStage.DRONE, species);
    }

    private LootPoolSingletonContainer.Builder<?> beeLoot(BeeLifeStage type, ResourceLocation species) {
        return LootItem.m_79579_((ItemLike)this.beeItem(type)).m_79078_(OrganismFunction.fromDefinition((ISpeciesType)SpeciesUtil.BEE_TYPE.get(), SpeciesUtil.getBeeSpecies(species)));
    }

    private Item saplingItem(TreeLifeStage type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TreeLifeStage.POLLEN -> ArboricultureItems.POLLEN_FERTILE.item();
            case TreeLifeStage.SAPLING -> ArboricultureItems.SAPLING.item();
        };
    }

    private Item beeItem(BeeLifeStage type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BeeLifeStage.QUEEN -> ApicultureItems.BEE_QUEEN.item();
            case BeeLifeStage.LARVAE -> ApicultureItems.BEE_LARVAE.item();
            case BeeLifeStage.PRINCESS -> ApicultureItems.BEE_PRINCESS.item();
            case BeeLifeStage.DRONE -> ApicultureItems.BEE_DRONE.item();
        };
    }

    protected void add(ResourceLocation location, String extension, LootTable.Builder builder) {
        this.entries.put((Object)location, (Object)new Entry(location, extension, builder));
    }

    public static class Entry {
        public final ResourceLocation defaultLocation;
        public final String extension;
        public final LootTable.Builder builder;

        public Entry(ResourceLocation defaultLocation, String extension, LootTable.Builder builder) {
            this.defaultLocation = defaultLocation;
            this.extension = extension;
            this.builder = builder;
        }

        public ResourceLocation getLocation() {
            return ForestryConstants.forestry(this.defaultLocation.m_135815_() + "/" + this.extension);
        }
    }
}

