/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SqueezerContainerRecipeBuilder {
    private ItemStack emptyContainer;
    private int processingTime;
    private ItemStack remnants;
    private float remnantsChance;

    public SqueezerContainerRecipeBuilder setEmptyContainer(ItemStack emptyContainer) {
        this.emptyContainer = emptyContainer;
        return this;
    }

    public SqueezerContainerRecipeBuilder setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
        return this;
    }

    public SqueezerContainerRecipeBuilder setRemnants(ItemStack remnants) {
        this.remnants = remnants;
        return this;
    }

    public SqueezerContainerRecipeBuilder setRemnantsChance(float remnantsChance) {
        this.remnantsChance = remnantsChance;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.emptyContainer, this.processingTime, this.remnants, this.remnantsChance));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack emptyContainer;
        private final int processingTime;
        private final ItemStack remnants;
        private final float remnantsChance;

        public Result(ResourceLocation id, ItemStack emptyContainer, int processingTime, ItemStack remnants, float remnantsChance) {
            this.id = id;
            this.emptyContainer = emptyContainer;
            this.processingTime = processingTime;
            this.remnants = remnants;
            this.remnantsChance = remnantsChance;
        }

        public void m_7917_(JsonObject json) {
            json.add("container", (JsonElement)RecipeSerializers.item(this.emptyContainer));
            json.addProperty("time", (Number)this.processingTime);
            json.add("remnants", (JsonElement)RecipeSerializers.item(this.remnants));
            json.addProperty("remnantsChance", (Number)Float.valueOf(this.remnantsChance));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.SQUEEZER_CONTAINER.serializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

