/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.models;

import forestry.api.client.IForestryClientApi;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.utils.ModUtil;
import forestry.cultivation.blocks.BlockPlanter;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.farming.blocks.BlockFarm;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.features.FarmingBlocks;
import forestry.modules.features.FeatureBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ForestryBlockStateProvider
extends BlockStateProvider {
    public ForestryBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "forestry", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (BlockFarm block : FarmingBlocks.FARM.getBlocks()) {
            if (block.getType() == EnumFarmBlockType.PLAIN) {
                this.plainFarm(block);
            } else {
                this.singleFarm(block);
            }
            this.generic3d(block);
        }
        for (BlockTypePlanter blockTypePlanter : BlockTypePlanter.values()) {
            ModelFile.ExistingModelFile file = this.models().getExistingFile(this.modBlock(blockTypePlanter.m_7912_()));
            this.horizontalBlock((Block)((FeatureBlock)CultivationBlocks.PLANTER.get(blockTypePlanter, BlockPlanter.Mode.MANUAL)).block(), (ModelFile)file);
            this.horizontalBlock((Block)((FeatureBlock)CultivationBlocks.PLANTER.get(blockTypePlanter, BlockPlanter.Mode.MANAGED)).block(), (ModelFile)file);
        }
        this.simpleBlock(CoreBlocks.BOG_EARTH.block());
        this.simpleBlock(CoreBlocks.HUMUS.block());
        this.simpleBlock(CoreBlocks.APATITE_ORE.block());
        this.simpleBlock(CoreBlocks.DEEPSLATE_APATITE_ORE.block());
        this.simpleBlock(CoreBlocks.TIN_ORE.block());
        this.simpleBlock(CoreBlocks.DEEPSLATE_TIN_ORE.block());
        this.simpleBlock(CoreBlocks.RAW_TIN_BLOCK.block());
        this.generic3d(CoreBlocks.APATITE_ORE.block());
        this.generic3d(CoreBlocks.DEEPSLATE_APATITE_ORE.block());
        this.generic3d(CoreBlocks.TIN_ORE.block());
        this.generic3d(CoreBlocks.DEEPSLATE_TIN_ORE.block());
        this.generic3d(CoreBlocks.RAW_TIN_BLOCK.block());
        this.generic2d(CoreItems.RAW_TIN);
        this.generic2d(CoreItems.INGOT_TIN);
        this.generic2d(CoreItems.GEAR_TIN);
        this.generic2d(CoreItems.INGOT_BRONZE);
        this.generic2d(CoreItems.GEAR_BRONZE);
        this.generic2d(CoreItems.GEAR_COPPER);
        for (Enum enum_ : ForestryFluids.values()) {
            Block block = ((ForestryFluids)enum_).getFeature().fluidBlock().block();
            ModelFile blockModel = this.particleOnly(ForestryBlockStateProvider.path(block), ((ForestryFluids)enum_).getFeature().properties().resources[0]);
            this.getVariantBuilder(block).partialState().modelForState().modelFile(blockModel).addModel();
        }
        for (ForestryLeafType treeType : ForestryLeafType.values()) {
            Object defaultBlock = ((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(treeType)).block();
            Object b = ((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(treeType)).block();
            Object decorativeBlock = ((FeatureBlock)ArboricultureBlocks.LEAVES_DECORATIVE.get(treeType)).block();
            ResourceLocation particle = IForestryClientApi.INSTANCE.getTreeManager().getLeafSprite(treeType.getIndividual().getSpecies()).get(false, true);
            ModelBuilder file = ((BlockModelBuilder)this.models().getBuilder(ForestryBlockStateProvider.path(defaultBlock))).texture("particle", particle);
            this.getVariantBuilder((Block)defaultBlock).partialState().modelForState().modelFile((ModelFile)file).addModel();
            this.getVariantBuilder((Block)b).partialState().modelForState().modelFile((ModelFile)file).addModel();
            this.getVariantBuilder((Block)decorativeBlock).partialState().modelForState().modelFile((ModelFile)file).addModel();
            this.generic3d((Block)defaultBlock);
            this.generic3d((Block)b, (Block)defaultBlock);
            this.generic3d((Block)decorativeBlock, (Block)defaultBlock);
        }
        this.getVariantBuilder((Block)ArboricultureBlocks.LEAVES.block()).partialState().modelForState().modelFile(this.particleOnly(ArboricultureBlocks.LEAVES.getName(), this.blockTexture(Blocks.f_50050_))).addModel();
    }

    private ModelFile particleOnly(String path, ResourceLocation particleTexture) {
        return ((BlockModelBuilder)this.models().getBuilder(path)).texture("particle", particleTexture);
    }

    private void singleFarm(BlockFarm block) {
        EnumFarmMaterial material = block.getFarmMaterial();
        Block base = material.getBase();
        ResourceLocation texture = this.modLoc("block/farm/" + block.getType().m_7912_());
        this.getVariantBuilder(block).partialState().modelForState().modelFile(this.farmPillar(ForestryBlockStateProvider.path(block), base, texture, texture)).addModel();
    }

    private void plainFarm(BlockFarm block) {
        EnumFarmMaterial material = block.getFarmMaterial();
        Block base = material.getBase();
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with(BlockFarm.STATE, (Comparable)((Object)BlockFarm.State.PLAIN)).modelForState().modelFile(this.farmPillar(ForestryBlockStateProvider.path(block), base, this.modLoc("block/farm/top"), this.modLoc("block/farm/plain"))).addModel()).partialState().with(BlockFarm.STATE, (Comparable)((Object)BlockFarm.State.BAND)).modelForState().modelFile(this.farmPillar(ForestryBlockStateProvider.path(block) + "_band", base, this.modLoc("block/farm/top"), this.modLoc("block/farm/band"))).addModel();
    }

    private ModelFile farmPillar(String path, Block base, ResourceLocation top, ResourceLocation side) {
        ModelFile.UncheckedModelFile baseModel = ForestryBlockStateProvider.file(this.blockTexture(base));
        return ((BlockModelBuilder)((CompositeModelBuilder)((BlockModelBuilder)this.models().getBuilder(path)).customLoader(CompositeModelBuilder::begin)).child("base", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)baseModel)).renderType("solid"))).child("overlay", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.mcFile("cube_column"))).texture("end", top)).texture("side", side)).renderType("cutout"))).itemRenderOrder(new String[]{"base", "overlay"}).end()).parent((ModelFile)baseModel);
    }

    protected static ResourceLocation withSuffix(ResourceLocation loc, String suffix) {
        return new ResourceLocation(loc.m_135827_(), loc.m_135815_() + suffix);
    }

    public void generic3d(Block block, Block otherParent) {
        this.itemModels().withExistingParent(ForestryBlockStateProvider.path(block), this.modLoc("block/" + ForestryBlockStateProvider.path(otherParent)));
    }

    public void generic3d(Block block, ResourceLocation otherParentId) {
        this.itemModels().withExistingParent(ForestryBlockStateProvider.path(block), new ResourceLocation(otherParentId.m_135827_(), "block/" + otherParentId.m_135815_()));
    }

    protected ModelFile existingMcBlock(String path) {
        return this.models().getExistingFile(this.mcBlock(path));
    }

    public void generic3d(Block block) {
        String path = ForestryBlockStateProvider.path(block);
        this.itemModels().withExistingParent(path, this.modLoc("block/" + path));
    }

    public static String path(Block block) {
        return ModUtil.getRegistryName(block).m_135815_();
    }

    public static ModelFile.UncheckedModelFile file(ResourceLocation resourceLoc) {
        return new ModelFile.UncheckedModelFile(resourceLoc);
    }

    public ModelFile.UncheckedModelFile modFile(String path) {
        return ForestryBlockStateProvider.file(this.modBlock(path));
    }

    public ModelFile.UncheckedModelFile mcFile(String path) {
        return ForestryBlockStateProvider.file(this.mcBlock(path));
    }

    public ResourceLocation modBlock(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation mcBlock(String name) {
        return this.mcLoc("block/" + name);
    }

    public void generic2d(ItemLike item) {
        this.generic2d(ModUtil.getRegistryName(item.m_5456_()));
    }

    public void generic2d(ResourceLocation itemId) {
        this.layer0(itemId, "item/generated");
    }

    public void layer0(ResourceLocation itemId, String parentName) {
        String path = itemId.m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(parentName))).texture("layer0", new ResourceLocation(itemId.m_135827_(), "item/" + path));
    }
}

