/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.models;

import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.VanillaWoodType;
import forestry.arboriculture.blocks.BlockForestryDoor;
import forestry.arboriculture.blocks.BlockForestryFence;
import forestry.arboriculture.blocks.BlockForestryFenceGate;
import forestry.arboriculture.blocks.BlockForestryLog;
import forestry.arboriculture.blocks.BlockForestrySlab;
import forestry.arboriculture.blocks.BlockForestryStairs;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.core.data.models.ForestryBlockStateProvider;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ForestryWoodModelProvider
extends ForestryBlockStateProvider {
    public ForestryWoodModelProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, exFileHelper);
    }

    @Override
    protected void registerStatesAndModels() {
        Object planks;
        for (VanillaWoodType vanillaWoodType : VanillaWoodType.VALUES) {
            planks = ((FeatureBlock)ArboricultureBlocks.PLANKS_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String woodTypeName = vanillaWoodType.m_7912_();
            String planksName = woodTypeName + "_planks";
            ModelFile planksModel = this.existingMcBlock(planksName);
            this.simpleBlock((Block)planks, planksModel);
            this.generic3d((Block)planks, this.mcLoc(planksName));
            BlockForestryLog log = (BlockForestryLog)((FeatureBlock)ArboricultureBlocks.LOGS_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String logName = woodTypeName + "_log";
            ModelFile logModel = this.existingMcBlock(logName);
            this.axisBlock(log, logModel, logModel);
            this.generic3d((Block)log, this.mcLoc(logName));
            BlockForestryLog wood = (BlockForestryLog)((FeatureBlock)ArboricultureBlocks.WOOD_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String woodName = woodTypeName + "_wood";
            ModelFile woodModel = this.existingMcBlock(woodName);
            this.axisBlock(wood, woodModel, woodModel);
            this.generic3d((Block)wood, this.mcLoc(woodName));
            BlockForestryLog strippedLog = (BlockForestryLog)((FeatureBlock)ArboricultureBlocks.STRIPPED_LOGS_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String strippedLogName = "stripped_" + woodTypeName + "_log";
            ModelFile strippedLogModel = this.existingMcBlock(strippedLogName);
            this.axisBlock(strippedLog, strippedLogModel, strippedLogModel);
            this.generic3d((Block)strippedLog, this.mcLoc(strippedLogName));
            BlockForestryLog strippedWood = (BlockForestryLog)((FeatureBlock)ArboricultureBlocks.STRIPPED_WOOD_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String strippedWoodName = "stripped_" + woodTypeName + "_wood";
            ModelFile strippedWoodModel = this.existingMcBlock(strippedWoodName);
            this.axisBlock(strippedWood, strippedWoodModel, strippedWoodModel);
            this.generic3d((Block)strippedWood, this.mcLoc(strippedWoodName));
            SlabBlock slab = (SlabBlock)((FeatureBlock)ArboricultureBlocks.SLABS_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String slabName = woodTypeName + "_slab";
            ModelFile bottomSlabModel = this.existingMcBlock(slabName);
            ModelFile topSlabModel = this.existingMcBlock(slabName + "_top");
            this.slabBlock(slab, bottomSlabModel, topSlabModel, planksModel);
            this.generic3d((Block)slab, this.mcLoc(slabName));
            StairBlock stairs = (StairBlock)((FeatureBlock)ArboricultureBlocks.STAIRS_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String stairsName = woodTypeName + "_stairs";
            ModelFile stairsModel = this.existingMcBlock(stairsName);
            ModelFile innerStairsModel = this.existingMcBlock(stairsName + "_inner");
            ModelFile outerStairsModel = this.existingMcBlock(stairsName + "_outer");
            this.stairsBlock(stairs, stairsModel, innerStairsModel, outerStairsModel);
            this.generic3d((Block)stairs, this.mcLoc(stairsName));
            BlockForestryFence fence = (BlockForestryFence)((FeatureBlock)ArboricultureBlocks.FENCES_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String fenceName = woodTypeName + "_fence";
            ModelFile fencePostModel = this.existingMcBlock(fenceName + "_post");
            ModelFile fenceSideModel = this.existingMcBlock(fenceName + "_side");
            ModelFile fenceInventoryModel = this.existingMcBlock(fenceName + "_inventory");
            this.fourWayBlock((CrossCollisionBlock)fence, fencePostModel, fenceSideModel);
            this.itemModels().withExistingParent(ForestryWoodModelProvider.path((Block)fence), fenceInventoryModel.getLocation());
            BlockForestryFenceGate fenceGate = (BlockForestryFenceGate)((FeatureBlock)ArboricultureBlocks.FENCE_GATES_VANILLA_FIREPROOF.get(vanillaWoodType)).block();
            String fenceGateName = woodTypeName + "_fence_gate";
            ModelFile gateModel = this.existingMcBlock(fenceGateName);
            ModelFile gateOpenModel = this.existingMcBlock(fenceGateName + "_open");
            ModelFile gateWallModel = this.existingMcBlock(fenceGateName + "_wall");
            ModelFile gateWallOpenModel = this.existingMcBlock(fenceGateName + "_wall_open");
            this.fenceGateBlock(fenceGate, gateModel, gateOpenModel, gateWallModel, gateWallOpenModel);
            this.generic3d((Block)fenceGate, this.mcLoc(fenceGateName));
        }
        for (Enum enum_ : ForestryWoodType.VALUES) {
            planks = ((FeatureBlock)ArboricultureBlocks.PLANKS.get((ForestryWoodType)enum_)).block();
            Object fireproofPlanks = ((FeatureBlock)ArboricultureBlocks.PLANKS_FIREPROOF.get((ForestryWoodType)enum_)).block();
            ModelFile planksModel = this.cubeAll((Block)planks);
            this.simpleBlock((Block)planks);
            this.simpleBlock((Block)fireproofPlanks, planksModel);
            this.generic3d((Block)planks);
            this.generic3d((Block)fireproofPlanks, (Block)planks);
            BlockForestryLog log = (BlockForestryLog)((FeatureBlock)ArboricultureBlocks.LOGS.get((ForestryWoodType)enum_)).block();
            ResourceLocation logTexture = this.blockTexture((Block)log);
            this.logLike((ForestryWoodType)enum_, ArboricultureBlocks.LOGS, ArboricultureBlocks.LOGS_FIREPROOF, logTexture, ForestryWoodModelProvider.withSuffix(logTexture, "_top"));
            this.logLike((ForestryWoodType)enum_, ArboricultureBlocks.WOOD, ArboricultureBlocks.WOOD_FIREPROOF, logTexture, logTexture);
            BlockForestrySlab slab = (BlockForestrySlab)((FeatureBlock)ArboricultureBlocks.SLABS.get((ForestryWoodType)enum_)).block();
            BlockForestrySlab fireproofSlab = (BlockForestrySlab)((FeatureBlock)ArboricultureBlocks.SLABS_FIREPROOF.get((ForestryWoodType)enum_)).block();
            ResourceLocation planksLoc = this.blockTexture((Block)planks);
            ModelBuilder bottomSlabModel = this.models().slab(ForestryWoodModelProvider.path((Block)slab), planksLoc, planksLoc, planksLoc);
            ModelBuilder topSlabModel = this.models().slabTop(ForestryWoodModelProvider.path((Block)slab) + "_top", planksLoc, planksLoc, planksLoc);
            this.slabBlock(slab, (ModelFile)bottomSlabModel, (ModelFile)topSlabModel, planksModel);
            this.slabBlock(fireproofSlab, (ModelFile)bottomSlabModel, (ModelFile)topSlabModel, planksModel);
            this.generic3d((Block)slab);
            this.generic3d((Block)fireproofSlab, (Block)slab);
            BlockForestryStairs stairs = (BlockForestryStairs)((FeatureBlock)ArboricultureBlocks.STAIRS.get((ForestryWoodType)enum_)).block();
            BlockForestryStairs fireproofStairs = (BlockForestryStairs)((FeatureBlock)ArboricultureBlocks.STAIRS_FIREPROOF.get((ForestryWoodType)enum_)).block();
            ModelBuilder stairsModel = this.models().stairs(ForestryWoodModelProvider.path((Block)stairs), planksLoc, planksLoc, planksLoc);
            ModelBuilder innerStairsModel = this.models().stairsInner(ForestryWoodModelProvider.path((Block)stairs) + "_inner", planksLoc, planksLoc, planksLoc);
            ModelBuilder outerStairsModel = this.models().stairsOuter(ForestryWoodModelProvider.path((Block)stairs) + "_outer", planksLoc, planksLoc, planksLoc);
            this.stairsBlock(stairs, (ModelFile)stairsModel, (ModelFile)innerStairsModel, (ModelFile)outerStairsModel);
            this.stairsBlock(fireproofStairs, (ModelFile)stairsModel, (ModelFile)innerStairsModel, (ModelFile)outerStairsModel);
            this.generic3d((Block)stairs);
            this.generic3d((Block)fireproofStairs, (Block)stairs);
            BlockForestryFence fence = (BlockForestryFence)((FeatureBlock)ArboricultureBlocks.FENCES.get((ForestryWoodType)enum_)).block();
            BlockForestryFence fireproofFence = (BlockForestryFence)((FeatureBlock)ArboricultureBlocks.FENCES_FIREPROOF.get((ForestryWoodType)enum_)).block();
            ModelBuilder fencePostModel = this.models().fencePost(ForestryWoodModelProvider.path((Block)fence) + "_post", planksLoc);
            ModelBuilder fenceSideModel = this.models().fenceSide(ForestryWoodModelProvider.path((Block)fence) + "_side", planksLoc);
            ModelBuilder fenceInventoryModel = this.models().fenceInventory(ForestryWoodModelProvider.path((Block)fence) + "_inventory", planksLoc);
            this.fourWayBlock((CrossCollisionBlock)fence, (ModelFile)fencePostModel, (ModelFile)fenceSideModel);
            this.fourWayBlock((CrossCollisionBlock)fireproofFence, (ModelFile)fencePostModel, (ModelFile)fenceSideModel);
            this.itemModels().withExistingParent(ForestryWoodModelProvider.path((Block)fence), fenceInventoryModel.getLocation());
            this.itemModels().withExistingParent(ForestryWoodModelProvider.path((Block)fireproofFence), fenceInventoryModel.getLocation());
            BlockForestryFenceGate fenceGate = (BlockForestryFenceGate)((FeatureBlock)ArboricultureBlocks.FENCE_GATES.get((ForestryWoodType)enum_)).block();
            BlockForestryFenceGate fireproofFenceGate = (BlockForestryFenceGate)((FeatureBlock)ArboricultureBlocks.FENCE_GATES_FIREPROOF.get((ForestryWoodType)enum_)).block();
            ModelBuilder gateModel = this.models().fenceGate(ForestryWoodModelProvider.path((Block)fenceGate), planksLoc);
            ModelBuilder gateOpenModel = this.models().fenceGateOpen(ForestryWoodModelProvider.path((Block)fenceGate) + "_open", planksLoc);
            ModelBuilder gateWallModel = this.models().fenceGateWall(ForestryWoodModelProvider.path((Block)fenceGate) + "_wall", planksLoc);
            ModelBuilder gateWallOpenModel = this.models().fenceGateWallOpen(ForestryWoodModelProvider.path((Block)fenceGate) + "_wall_open", planksLoc);
            this.fenceGateBlock(fenceGate, (ModelFile)gateModel, (ModelFile)gateOpenModel, (ModelFile)gateWallModel, (ModelFile)gateWallOpenModel);
            this.fenceGateBlock(fireproofFenceGate, (ModelFile)gateModel, (ModelFile)gateOpenModel, (ModelFile)gateWallModel, (ModelFile)gateWallOpenModel);
            this.generic3d((Block)fenceGate);
            this.generic3d((Block)fireproofFenceGate, (Block)fenceGate);
            BlockForestryDoor door = (BlockForestryDoor)((FeatureBlock)ArboricultureBlocks.DOORS.get((ForestryWoodType)enum_)).block();
            this.doorBlock(door, ForestryWoodModelProvider.withSuffix(this.blockTexture((Block)door), "_bottom"), ForestryWoodModelProvider.withSuffix(this.blockTexture((Block)door), "_top"));
            this.generic2d((ItemLike)door);
        }
    }

    private void logLike(ForestryWoodType woodType, FeatureBlockGroup<BlockForestryLog, ForestryWoodType> logs, FeatureBlockGroup<BlockForestryLog, ForestryWoodType> fireproofLogs, ResourceLocation sideTexture, ResourceLocation topTexture) {
        BlockForestryLog wood = (BlockForestryLog)((FeatureBlock)logs.get(woodType)).block();
        BlockForestryLog fireproofWood = (BlockForestryLog)((FeatureBlock)fireproofLogs.get(woodType)).block();
        ModelBuilder woodModel = this.models().cubeColumn(ForestryWoodModelProvider.path((Block)wood), sideTexture, topTexture);
        this.axisBlock(wood, (ModelFile)woodModel, (ModelFile)woodModel);
        this.axisBlock(fireproofWood, (ModelFile)woodModel, (ModelFile)woodModel);
        this.generic3d((Block)wood);
        this.generic3d((Block)fireproofWood, (Block)wood);
    }
}

