/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FluidProperties;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;

public class BlockForestryFluid
extends LiquidBlock {
    private final boolean spreadsFire;
    private final int flammability;
    private final Color color;
    private final boolean freezing;
    private final boolean burning;
    private final float explosionPower;
    private final boolean explodes;

    public BlockForestryFluid(FeatureFluid feature) {
        super(feature::fluid, BlockBehaviour.Properties.m_60939_((Material)(feature.properties().temperature > 505 ? Material.f_76307_ : Material.f_76305_)).m_60910_().m_222994_());
        FluidProperties properties = feature.properties();
        this.flammability = properties.flammability;
        this.spreadsFire = properties.spreadsFire;
        this.color = properties.particleColor;
        this.freezing = properties.temperature < 270;
        this.burning = properties.temperature > 505;
        this.explosionPower = 4.0f * (float)this.flammability / 300.0f;
        this.explodes = this.explosionPower > 1.0f;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity entity) {
        if (this.freezing) {
            entity.m_146924_(true);
        } else if (this.burning) {
            entity.m_20254_(5);
            entity.m_6469_(DamageSource.f_19308_, 1.0f);
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.spreadsFire ? 30 : 0;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.flammability;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.spreadsFire;
    }

    private static boolean isFlammable(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.isFlammable(world, pos, Direction.UP);
    }

    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return this.spreadsFire && this.flammability == 0;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean m_6724_(BlockState pState) {
        return this.burning || this.explodes;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (this.burning) {
            int rangeUp = rand.m_188503_(3);
            for (int i = 0; i < rangeUp; ++i) {
                BlockState blockState = world.m_8055_(new BlockPos(x += rand.m_188503_(3) - 1, ++y, z += rand.m_188503_(3) - 1));
                if (blockState.m_60767_() == Material.f_76296_) {
                    if (!BlockForestryFluid.isNeighborFlammable((Level)world, x, y, z)) continue;
                    world.m_46597_(new BlockPos(x, y, z), Blocks.f_50083_.m_49966_());
                    return;
                }
                if (!blockState.m_60767_().m_76334_()) continue;
                return;
            }
            if (rangeUp == 0) {
                int startX = x;
                int startZ = z;
                for (int i = 0; i < 3; ++i) {
                    x = startX + rand.m_188503_(3) - 1;
                    z = startZ + rand.m_188503_(3) - 1;
                    BlockPos posAbove = new BlockPos(pos.m_123341_(), y + 1, z);
                    if (!world.m_46859_(posAbove) || !BlockForestryFluid.isFlammable((BlockGetter)world, new BlockPos(x, y, z))) continue;
                    world.m_46597_(posAbove, Blocks.f_50083_.m_49966_());
                }
            }
        }
        if (this.explosionPower > 1.0f && BlockForestryFluid.isNearFire((Level)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            world.m_46597_(pos, Blocks.f_50083_.m_49966_());
            world.m_46518_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.explosionPower, true, Explosion.BlockInteraction.DESTROY);
        }
    }

    private static boolean isNeighborFlammable(Level world, int x, int y, int z) {
        return BlockForestryFluid.isFlammable((BlockGetter)world, new BlockPos(x - 1, y, z)) || BlockForestryFluid.isFlammable((BlockGetter)world, new BlockPos(x + 1, y, z)) || BlockForestryFluid.isFlammable((BlockGetter)world, new BlockPos(x, y, z - 1)) || BlockForestryFluid.isFlammable((BlockGetter)world, new BlockPos(x, y, z + 1)) || BlockForestryFluid.isFlammable((BlockGetter)world, new BlockPos(x, y - 1, z)) || BlockForestryFluid.isFlammable((BlockGetter)world, new BlockPos(x, y + 1, z));
    }

    private static boolean isNearFire(Level world, int x, int y, int z) {
        AABB boundingBox = new AABB((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1));
        return BlockPos.m_121921_((AABB)boundingBox.m_82406_(0.001)).noneMatch(pos -> {
            BlockState state = world.m_8055_(pos);
            return state.m_204336_(BlockTags.f_13076_) || state.m_60713_(Blocks.f_49991_) || state.isBurning((BlockGetter)world, pos);
        });
    }
}

