/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.api.ForestryConstants;
import forestry.api.modules.ForestryModuleIds;
import forestry.core.items.definitions.DrinkProperties;
import forestry.core.utils.ModUtil;
import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

@FeatureProvider
public enum ForestryFluids {
    BIO_ETHANOL(properties -> properties.particleColor(new Color(255, 111, 0)).density(790).viscosity(1000).flammability(300).spreadsFire()),
    BIOMASS(properties -> properties.particleColor(new Color(100, 132, 41)).density(400).viscosity(6560).flammability(100)),
    GLASS(properties -> properties.particleColor(new Color(164, 164, 164)).density(2400).viscosity(10000).flammability(0).spreadsFire().temperature(1400)),
    HONEY(properties -> properties.particleColor(new Color(255, 196, 35)).density(1420).viscosity(75600).drinkProperties(2, 0.2f, 64)),
    ICE(properties -> properties.particleColor(new Color(175, 242, 255)).density(520).viscosity(1000).temperature(265)),
    JUICE(properties -> properties.particleColor(new Color(168, 201, 114)).drinkProperties(2, 0.2f, 32)),
    SEED_OIL(properties -> properties.particleColor(new Color(255, 255, 168)).density(885).viscosity(5000).spreadsFire().flammability(2)),
    SHORT_MEAD(properties -> properties.particleColor(new Color(239, 154, 56)).density(1000).viscosity(1200).spreadsFire().flammability(4).drinkProperties(1, 0.2f, 32));

    private static final Map<ResourceLocation, ForestryFluids> tagToFluid;
    private final ResourceLocation tag;
    private final FeatureFluid feature;
    @Nullable
    private final FeatureItem<BucketItem> bucket;

    private ForestryFluids(UnaryOperator<FeatureFluid.Builder> properties) {
        IFeatureRegistry registry = ModFeatureRegistry.get(ForestryModuleIds.FLUIDS);
        this.feature = ((FeatureFluid.Builder)properties.apply(registry.fluid(this.name().toLowerCase(Locale.ENGLISH)))).bucket(this::getBucket).create();
        this.bucket = this.hasBucket() ? registry.item(() -> new BucketItem(this::getFluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(CreativeModeTab.f_40753_)), "bucket_" + this.name().toLowerCase(Locale.ENGLISH)) : null;
        this.tag = ForestryConstants.forestry(this.feature.getName());
    }

    protected boolean hasBucket() {
        return true;
    }

    public int getTemperature() {
        return 295;
    }

    public final ResourceLocation getTag() {
        return this.tag;
    }

    public FeatureFluid getFeature() {
        return this.feature;
    }

    @Nullable
    public FeatureItem<BucketItem> getBucketFeature() {
        return this.bucket;
    }

    @Nullable
    public BucketItem getBucket() {
        return this.bucket != null ? this.bucket.item() : null;
    }

    public final Fluid getFluid() {
        return this.feature.fluid();
    }

    public final Fluid getFlowing() {
        return this.feature.flowing();
    }

    public final FluidStack getFluid(int mb) {
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, mb);
    }

    public final Color getParticleColor() {
        return this.feature.properties().particleColor;
    }

    public final boolean is(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    public final boolean is(FluidStack fluidStack) {
        return this.getFluid() == fluidStack.getFluid();
    }

    public static boolean areEqual(Fluid fluid, FluidStack fluidStack) {
        return fluid == fluidStack.getFluid();
    }

    @Nullable
    public static ForestryFluids getFluidDefinition(Fluid fluid) {
        return tagToFluid.get(ModUtil.getRegistryName(fluid));
    }

    @Nullable
    public static ForestryFluids getFluidDefinition(FluidStack stack) {
        if (!stack.isEmpty()) {
            return ForestryFluids.getFluidDefinition(stack.getFluid());
        }
        return null;
    }

    public List<ItemStack> getOtherContainers() {
        return Collections.emptyList();
    }

    @Nullable
    public DrinkProperties getDrinkProperties() {
        return this.feature.properties().properties;
    }

    static {
        tagToFluid = new HashMap<ResourceLocation, ForestryFluids>();
        for (ForestryFluids fluidDefinition : ForestryFluids.values()) {
            tagToFluid.put(ForestryConstants.forestry(fluidDefinition.feature.getName()), fluidDefinition);
        }
    }
}

