/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.plugin.IGenomeBuilder;
import forestry.core.genetics.Karyotype;
import java.util.IdentityHashMap;
import java.util.Map;

public final class Genome
implements IGenome {
    final ImmutableMap<IChromosome<?>, AllelePair<?>> chromosomes;
    private final IKaryotype karyotype;
    private boolean isDefaultGenome;
    private boolean hasCachedDefaultGenome;

    public Genome(IKaryotype karyotype, ImmutableMap<IChromosome<?>, AllelePair<?>> chromosomes) {
        this.karyotype = karyotype;
        this.chromosomes = chromosomes;
    }

    public static IGenome fromUnsortedAlleles(Karyotype karyotype, Map<IChromosome<?>, AllelePair<?>> map) {
        ImmutableMap.Builder sorted = ImmutableMap.builderWithExpectedSize((int)map.size());
        for (IChromosome chromosome : karyotype.getChromosomes()) {
            sorted.put((Object)chromosome, map.get(chromosome));
        }
        return new Genome(karyotype, sorted.buildOrThrow());
    }

    @Override
    public ImmutableList<AllelePair<?>> getAllelePairs() {
        return this.chromosomes.values().asList();
    }

    @Override
    public IKaryotype getKaryotype() {
        return this.karyotype;
    }

    @Override
    public <A extends IAllele> AllelePair<A> getAllelePair(IChromosome<A> chromosomeType) {
        return (AllelePair)this.chromosomes.get(chromosomeType);
    }

    @Override
    public boolean isDefaultGenome() {
        if (!this.hasCachedDefaultGenome) {
            Genome defaultGenome = (Genome)this.getActiveValue(this.karyotype.getSpeciesChromosome()).getDefaultGenome();
            this.isDefaultGenome = this == defaultGenome || this.isSameAlleles(defaultGenome);
            this.hasCachedDefaultGenome = true;
        }
        return this.isDefaultGenome;
    }

    @Override
    public ImmutableMap<IChromosome<?>, AllelePair<?>> getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public IGenome copyWith(Map<IChromosome<?>, IAllele> alleles) {
        if (alleles.isEmpty()) {
            return this;
        }
        Builder builder = new Builder(this.getKaryotype());
        boolean isDefault = true;
        for (Map.Entry entry : this.chromosomes.entrySet()) {
            IChromosome chromosome = (IChromosome)entry.getKey();
            AllelePair pair = (AllelePair)entry.getValue();
            IAllele allele = alleles.get(chromosome);
            if (allele == null || allele.equals(pair.active())) {
                builder.setUnchecked(chromosome, pair);
                continue;
            }
            builder.setUnchecked(chromosome, new AllelePair<IAllele>(allele, allele));
            isDefault = false;
        }
        if (isDefault) {
            return this;
        }
        return builder.build();
    }

    @Override
    public boolean isSameAlleles(IGenome other) {
        return other.getKaryotype() == this.karyotype && this.chromosomes.equals(other.getChromosomes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Genome genome = (Genome)o;
        if (!this.chromosomes.equals(genome.chromosomes)) {
            return false;
        }
        return this.karyotype.equals(genome.karyotype);
    }

    public int hashCode() {
        int result = this.chromosomes.hashCode();
        result = 31 * result + this.karyotype.hashCode();
        return result;
    }

    public static class Builder
    implements IGenomeBuilder {
        private final IKaryotype karyotype;
        private final IdentityHashMap<IChromosome<?>, IAllele> active = new IdentityHashMap();
        private final IdentityHashMap<IChromosome<?>, IAllele> inactive = new IdentityHashMap();

        public Builder(IKaryotype karyotype) {
            Preconditions.checkNotNull((Object)karyotype);
            this.karyotype = karyotype;
        }

        @Override
        public <A extends IAllele> void set(IChromosome<A> chromosome, A allele) {
            if (this.karyotype.isAlleleValid(chromosome, allele)) {
                this.active.put(chromosome, allele);
                this.inactive.put(chromosome, allele);
            }
        }

        @Override
        public <A extends IAllele> void setActive(IChromosome<A> chromosome, A allele) {
            if (!this.karyotype.isAlleleValid(chromosome, allele)) {
                throw new IllegalArgumentException("Invalid allele " + allele.alleleId() + " for chromosome " + chromosome.id());
            }
            this.active.put(chromosome, allele);
        }

        @Override
        public <A extends IAllele> void setInactive(IChromosome<A> chromosome, A allele) {
            if (this.karyotype.isAlleleValid(chromosome, allele)) {
                this.inactive.put(chromosome, allele);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.inactive.isEmpty() && this.active.isEmpty();
        }

        @Override
        public void setRemainingDefault() {
            for (Map.Entry entry : this.karyotype.getDefaultAlleles().entrySet()) {
                IChromosome chromosome = (IChromosome)entry.getKey();
                IAllele defaultAllele = (IAllele)entry.getValue();
                if (!this.active.containsKey(chromosome)) {
                    this.active.put(chromosome, defaultAllele);
                }
                if (this.inactive.containsKey(chromosome)) continue;
                this.inactive.put(chromosome, defaultAllele);
            }
        }

        @Override
        public IGenome build() {
            if (this.karyotype.size() != this.active.size()) {
                StringBuilder msg = new StringBuilder("Tried to build genome, but the following chromosomes are missing from the karyotype: { ");
                for (IChromosome chromosome : this.karyotype.getChromosomes()) {
                    if (this.active.containsKey(chromosome)) continue;
                    msg.append(chromosome.id());
                    msg.append(' ');
                }
                msg.append('}');
                throw new IllegalStateException(msg.toString());
            }
            ImmutableMap.Builder genome = new ImmutableMap.Builder();
            for (IChromosome chromosome : this.karyotype.getChromosomes()) {
                IAllele active = this.active.get(chromosome);
                IAllele inactive = this.inactive.get(chromosome);
                if (active == null || inactive == null) {
                    throw new IllegalStateException("Tried to build genome, but the allele pair was incomplete for the following chromosome: " + chromosome.id());
                }
                genome.put((Object)chromosome, new AllelePair<IAllele>(active, inactive));
            }
            return new Genome(this.karyotype, genome.build());
        }
    }
}

