/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividualLiving;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IIntegerChromosome;
import forestry.core.genetics.Individual;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public abstract class IndividualLiving<S extends ISpecies<I>, I extends IIndividualLiving, T extends ISpeciesType<S, I>>
extends Individual<S, I, T>
implements IIndividualLiving {
    protected int health;
    protected int maxHealth;

    protected IndividualLiving(IGenome genome) {
        super(genome);
        int health;
        this.health = health = genome.getActiveValue(this.getLifespanChromosome());
        this.maxHealth = health;
    }

    protected IndividualLiving(IGenome genome, Optional<IGenome> mate, boolean analyzed, int health, int maxHealth) {
        super(genome, mate, analyzed);
        this.health = health;
        this.maxHealth = maxHealth;
    }

    protected static <I extends IIndividualLiving> Products.P5<RecordCodecBuilder.Mu<I>, IGenome, Optional<IGenome>, Boolean, Integer, Integer> livingFields(RecordCodecBuilder.Instance<I> instance, Codec<IGenome> genomeCodec) {
        return Individual.fields(instance, genomeCodec).and(instance.group((App)Codec.INT.fieldOf("health").forGetter(IIndividualLiving::getHealth), (App)Codec.INT.fieldOf("max_heath").forGetter(IIndividualLiving::getMaxHealth)));
    }

    protected abstract IIntegerChromosome getLifespanChromosome();

    @Override
    public boolean isAlive() {
        return this.health > 0;
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public final void setHealth(int health) {
        this.health = Mth.m_14045_((int)health, (int)0, (int)this.getMaxHealth());
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void age(Level level, float lifespanModifier) {
        float ageModifier;
        if (lifespanModifier < 0.0f) {
            this.setHealth(0);
            return;
        }
        if (lifespanModifier == 0.0f) {
            return;
        }
        for (ageModifier = 1.0f / lifespanModifier; ageModifier > 1.0f; ageModifier -= 1.0f) {
            this.decreaseHealth();
        }
        if (level.f_46441_.m_188501_() < ageModifier) {
            this.decreaseHealth();
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void copyPropertiesTo(I other) {
        super.copyPropertiesTo(other);
        IndividualLiving living = (IndividualLiving)other;
        living.health = this.health;
        living.maxHealth = this.maxHealth;
    }

    private void decreaseHealth() {
        if (this.health > 0) {
            this.setHealth(this.health - 1);
        }
    }
}

