/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import forestry.api.IForestryApi;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.api.plugin.IChromosomeBuilder;
import forestry.api.plugin.IGenomeBuilder;
import forestry.api.plugin.IKaryotypeBuilder;
import forestry.core.genetics.ChromosomeBuilder;
import forestry.core.genetics.Genome;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class Karyotype
implements IKaryotype {
    private final ImmutableMap<IChromosome<?>, ImmutableSet<? extends IAllele>> chromosomes;
    private final IRegistryChromosome<? extends ISpecies<?>> speciesChromosome;
    private final ImmutableMap<IChromosome<?>, ? extends IAllele> defaultAlleles;
    private final ResourceLocation defaultSpecies;
    private final Set<IChromosome<?>> weaklyInheritedChromosomes;
    private final Codec<IGenome> genomeCodec;

    public Karyotype(ImmutableMap<IChromosome<?>, ImmutableSet<? extends IAllele>> chromosomes, ImmutableMap<IChromosome<?>, ? extends IAllele> defaultAlleles, ResourceLocation defaultSpecies, Set<IChromosome<?>> weaklyInheritedChromosomes) {
        this.chromosomes = chromosomes;
        this.speciesChromosome = (IRegistryChromosome)chromosomes.keySet().asList().get(0);
        this.defaultAlleles = defaultAlleles;
        this.defaultSpecies = defaultSpecies;
        this.weaklyInheritedChromosomes = weaklyInheritedChromosomes;
        Keyable chromosomesKeyable = Keyable.forStrings(() -> this.chromosomes.keySet().stream().map(chromosome -> chromosome.id().toString()));
        this.genomeCodec = Codec.simpleMap(IForestryApi.INSTANCE.getAlleleManager().chromosomeCodec(), AllelePair.CODEC, (Keyable)chromosomesKeyable).xmap(map -> Genome.fromUnsortedAlleles(this, map), IGenome::getChromosomes).codec();
    }

    @Override
    public ImmutableList<IChromosome<?>> getChromosomes() {
        return this.chromosomes.keySet().asList();
    }

    @Override
    public boolean contains(IChromosome<?> chromosome) {
        return this.chromosomes.containsKey(chromosome);
    }

    @Override
    public IRegistryChromosome<? extends ISpecies<?>> getSpeciesChromosome() {
        return this.speciesChromosome;
    }

    @Override
    public int size() {
        return this.chromosomes.size();
    }

    @Override
    public <A extends IAllele> boolean isAlleleValid(IChromosome<A> chromosome, A allele) {
        ImmutableSet validAlleles = (ImmutableSet)this.chromosomes.get(chromosome);
        if (validAlleles != null) {
            if (chromosome instanceof IRegistryChromosome) {
                IRegistryChromosome registry = (IRegistryChromosome)chromosome;
                return !registry.isPopulated() || registry.isValidAllele(allele);
            }
            return validAlleles.contains(allele);
        }
        return false;
    }

    @Override
    public <A extends IAllele> boolean isChromosomeValid(IChromosome<A> chromosome) {
        return this.chromosomes.containsKey(chromosome);
    }

    @Override
    public <A extends IAllele> A getDefaultAllele(IChromosome<A> chromosome) {
        IAllele allele = (IAllele)this.defaultAlleles.get(chromosome);
        if (allele == null) {
            throw new IllegalArgumentException("Chromosome is not valid");
        }
        return (A)allele;
    }

    @Override
    public boolean isWeaklyInherited(IChromosome<?> chromosome) {
        return this.weaklyInheritedChromosomes.contains(chromosome);
    }

    @Override
    public <A extends IAllele> Collection<A> getAlleles(IChromosome<A> chromosome) {
        Preconditions.checkArgument((boolean)this.isChromosomeValid(chromosome), (Object)"Chromosome not present in karyotype");
        ImmutableSet validAlleles = (ImmutableSet)this.chromosomes.get(chromosome);
        if (validAlleles.isEmpty()) {
            return ((IRegistryChromosome)chromosome).alleles();
        }
        return validAlleles.asList();
    }

    @Override
    public ImmutableMap<IChromosome<?>, ? extends IAllele> getDefaultAlleles() {
        return this.defaultAlleles;
    }

    @Override
    public IGenomeBuilder createGenomeBuilder() {
        return new Genome.Builder(this);
    }

    @Override
    public ResourceLocation getDefaultSpecies() {
        return this.defaultSpecies;
    }

    @Override
    public Codec<IGenome> getGenomeCodec() {
        return this.genomeCodec;
    }

    public static class Builder
    implements IKaryotypeBuilder {
        private final LinkedHashMap<IChromosome<?>, ChromosomeBuilder<?>> chromosomes = new LinkedHashMap();
        @Nullable
        private IRegistryChromosome<? extends ISpecies<?>> speciesChromosome;
        @Nullable
        private ResourceLocation defaultSpeciesId;

        @Override
        public void setSpecies(IRegistryChromosome<? extends ISpecies<?>> species, ResourceLocation defaultId) {
            if (this.speciesChromosome != null && this.speciesChromosome != species) {
                throw new IllegalStateException("The species chromosome for this karyotype has already been set: " + this.speciesChromosome.id() + ", but tried setting to " + species.id());
            }
            this.speciesChromosome = species;
            this.defaultSpeciesId = defaultId;
        }

        @Override
        public void set(IRegistryChromosome<?> chromosome, ResourceLocation defaultId) {
            this.chromosomes.computeIfAbsent(chromosome, key -> new ChromosomeBuilder(chromosome));
        }

        @Override
        public <A extends IAllele> IChromosomeBuilder<A> get(IChromosome<A> chromosome) {
            return this.chromosomes.computeIfAbsent(chromosome, key -> new ChromosomeBuilder(chromosome));
        }

        public Karyotype build() {
            Preconditions.checkState((this.defaultSpeciesId != null && this.speciesChromosome != null ? 1 : 0) != 0, (Object)"IKaryotypeBuilder is missing a species chromosome.");
            ImmutableMap.Builder permittedAlleles = ImmutableMap.builderWithExpectedSize((int)(this.chromosomes.size() + 1));
            ImmutableMap.Builder defaultAlleles = ImmutableMap.builderWithExpectedSize((int)(this.chromosomes.size() + 1));
            Set<IChromosome<?>> weaklyInheritedChromosomes = Collections.newSetFromMap(new IdentityHashMap());
            permittedAlleles.put(this.speciesChromosome, (Object)ImmutableSet.of());
            defaultAlleles.put(this.speciesChromosome, IForestryApi.INSTANCE.getAlleleManager().registryAllele(this.defaultSpeciesId, this.speciesChromosome));
            for (Map.Entry<IChromosome<?>, ChromosomeBuilder<?>> entry : this.chromosomes.entrySet()) {
                IChromosome<?> chromosome = entry.getKey();
                ChromosomeBuilder<?> builder = entry.getValue();
                ImmutableSet permitted = builder.alleles.build();
                if (!(chromosome instanceof IRegistryChromosome) && permitted.isEmpty()) {
                    throw new IllegalStateException("Chromosome missing permitted alleles in karyotype.");
                }
                permittedAlleles.put(chromosome, (Object)permitted);
                defaultAlleles.put(chromosome, builder.defaultAllele);
                if (!builder.weaklyInherited) continue;
                weaklyInheritedChromosomes.add(chromosome);
            }
            return new Karyotype(permittedAlleles.build(), defaultAlleles.build(), this.defaultSpeciesId, weaklyInheritedChromosomes);
        }
    }
}

