/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.plugin.ISpeciesTypeBuilder;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public abstract class SpeciesType<S extends ISpecies<I>, I extends IIndividual>
implements ISpeciesType<S, I> {
    protected final ResourceLocation id;
    protected final IKaryotype karyotype;
    private final ILifeStage defaultStage;
    private final ImmutableMap<Item, ILifeStage> stages;
    protected final Reference2FloatOpenHashMap<Item> researchMaterials;
    private int speciesCount = -1;
    @Nullable
    private ImmutableMap<ResourceLocation, S> allSpecies;
    @Nullable
    protected IMutationManager<S> mutations;

    public SpeciesType(ResourceLocation id, IKaryotype karyotype, ISpeciesTypeBuilder builder) {
        this.id = id;
        this.karyotype = karyotype;
        this.defaultStage = builder.getDefaultStage();
        List<ILifeStage> stages = builder.getStages();
        ImmutableMap.Builder stagesBuilder = ImmutableMap.builderWithExpectedSize((int)stages.size());
        for (ILifeStage stage : stages) {
            stagesBuilder.put((Object)stage.getItemForm(), (Object)stage);
        }
        this.stages = stagesBuilder.build();
        this.researchMaterials = new Reference2FloatOpenHashMap();
        builder.buildResearchMaterials((Reference2FloatMap<Item>)this.researchMaterials);
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public S getDefaultSpecies() {
        return (S)((ISpecies)((IValueAllele)((Object)this.karyotype.getDefaultAllele(this.karyotype.getSpeciesChromosome()))).value());
    }

    @Override
    public ILifeStage getDefaultStage() {
        return this.defaultStage;
    }

    @Override
    public Collection<ILifeStage> getLifeStages() {
        return this.stages.values();
    }

    @Override
    @Nullable
    public ILifeStage getLifeStage(ItemStack stack) {
        return (ILifeStage)this.stages.get((Object)stack.m_41720_());
    }

    @Override
    public IKaryotype getKaryotype() {
        return this.karyotype;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onSpeciesRegistered(ImmutableMap<ResourceLocation, S> allSpecies, IMutationManager<S> mutations) {
        this.speciesCount = 0;
        for (ISpecies species : allSpecies.values()) {
            if (species.isSecret()) continue;
            ++this.speciesCount;
        }
        this.allSpecies = allSpecies;
        this.mutations = mutations;
    }

    @Override
    public IMutationManager<S> getMutations() {
        IMutationManager<S> manager = this.mutations;
        if (manager == null) {
            throw new IllegalStateException("Mutations have not been registered yet.");
        }
        return manager;
    }

    @Override
    public List<S> getAllSpecies() {
        this.checkSpecies();
        return this.allSpecies.values().asList();
    }

    @Override
    public S getSpecies(ResourceLocation id) {
        this.checkSpecies();
        ISpecies species = (ISpecies)this.allSpecies.get((Object)id);
        if (species == null) {
            throw new RuntimeException("No species was found with that ID: " + id);
        }
        return (S)species;
    }

    @Override
    public S getSpeciesSafe(ResourceLocation id) {
        this.checkSpecies();
        return (S)((ISpecies)this.allSpecies.get((Object)id));
    }

    @Override
    public S getRandomSpecies(RandomSource rand) {
        List<S> species = this.getAllSpecies();
        return (S)((ISpecies)species.get(rand.m_188503_(species.size())));
    }

    @Override
    public ImmutableSet<ResourceLocation> getAllSpeciesIds() {
        this.checkSpecies();
        return this.allSpecies.keySet();
    }

    @Override
    public int getSpeciesCount() {
        this.checkSpecies();
        return this.speciesCount;
    }

    private void checkSpecies() {
        if (this.allSpecies == null) {
            throw new IllegalStateException("Not all species have been registered for type: " + this.id);
        }
    }

    @Override
    public float getResearchSuitability(S species, ItemStack stack) {
        return this.researchMaterials.getFloat((Object)stack.m_41720_());
    }

    @Override
    public List<ItemStack> getResearchBounty(S species, Level level, GameProfile researcher, I individual, int bountyLevel) {
        List<IMutation<S>> mutationsFrom;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (level.f_46441_.m_188501_() < (float)bountyLevel / 16.0f && !(mutationsFrom = this.getMutations().getMutationsFrom(species)).isEmpty()) {
            ArrayList<IMutation<S>> unresearchedMutations = new ArrayList<IMutation<S>>();
            IBreedingTracker tracker = this.getBreedingTracker((LevelAccessor)level, researcher);
            for (IMutation<S> mutation : mutationsFrom) {
                if (tracker.isResearched(mutation)) continue;
                unresearchedMutations.add(mutation);
            }
            IMutation<S> chosenMutation = !unresearchedMutations.isEmpty() ? (IMutation<S>)unresearchedMutations.get(level.f_46441_.m_188503_(unresearchedMutations.size())) : mutationsFrom.get(level.f_46441_.m_188503_(mutationsFrom.size()));
            ItemStack researchNote = chosenMutation.getMutationNote(researcher);
            list.add(researchNote);
            return list;
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public ItemStack createStack(I individual, ILifeStage type) {
        if (!this.stages.containsValue((Object)type)) {
            throw new IllegalArgumentException("Invalid life stage for species type " + this.id + ": " + type);
        }
        return individual.createStack(type);
    }

    @Override
    public ItemStack createStack(ResourceLocation speciesId, ILifeStage stage) {
        S species = this.getSpecies(speciesId);
        return this.createStack(species.createIndividual(), stage);
    }

    @Override
    public I createRandomIndividual(RandomSource rand) {
        List<S> allSpecies = this.getAllSpecies();
        return ((ISpecies)allSpecies.get(rand.m_188503_(allSpecies.size()))).createIndividual();
    }

    @Override
    public IBreedingTracker createBreedingTracker(CompoundTag nbt) {
        IBreedingTracker tracker = this.createBreedingTracker();
        tracker.readFromNbt(nbt);
        return tracker;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }
}

