/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import forestry.Forestry;
import forestry.api.IForestryApi;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IAlleleManager;
import forestry.api.genetics.alleles.IAlleleNaming;
import forestry.api.genetics.alleles.IBooleanAllele;
import forestry.api.genetics.alleles.IBooleanChromosome;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IFloatAllele;
import forestry.api.genetics.alleles.IFloatChromosome;
import forestry.api.genetics.alleles.IIntegerAllele;
import forestry.api.genetics.alleles.IIntegerChromosome;
import forestry.api.genetics.alleles.IRegistryAllele;
import forestry.api.genetics.alleles.IRegistryAlleleValue;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.IValueChromosome;
import forestry.core.genetics.alleles.BooleanAllele;
import forestry.core.genetics.alleles.BooleanChromosome;
import forestry.core.genetics.alleles.FloatAllele;
import forestry.core.genetics.alleles.FloatChromosome;
import forestry.core.genetics.alleles.IntegerAllele;
import forestry.core.genetics.alleles.IntegerChromosome;
import forestry.core.genetics.alleles.RegistryAllele;
import forestry.core.genetics.alleles.RegistryChromosome;
import forestry.core.genetics.alleles.ValueAllele;
import forestry.core.genetics.alleles.ValueChromosome;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class AlleleManager
implements IAlleleManager {
    public static final int REGISTRATION_OPEN = 0;
    public static final int REGISTRATION_CHROMOSOMES_COMPLETE = 1;
    public static final int REGISTRATION_ALLELES_COMPLETE = 2;
    private final Float2ObjectOpenHashMap<IFloatAllele> dominantFloatAlleles = new Float2ObjectOpenHashMap();
    private final Float2ObjectOpenHashMap<IFloatAllele> floatAlleles = new Float2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<IIntegerAllele> dominantIntAlleles = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<IIntegerAllele> intAlleles = new Int2ObjectOpenHashMap();
    private final IBooleanAllele[] booleanAlleles = new BooleanAllele[4];
    private final HashMap<?, IValueAllele<?>> dominantValueAlleles = new HashMap();
    private final HashMap<?, IValueAllele<?>> valueAlleles = new HashMap();
    private final LinkedHashMap<ResourceLocation, IAllele> allelesByName = new LinkedHashMap();
    private final HashMap<ResourceLocation, IChromosome<?>> chromosomes = new HashMap();
    private final Codec<IAllele> alleleCodec = ResourceLocation.f_135803_.flatXmap(id -> {
        IAllele allele = this.getAllele((ResourceLocation)id);
        if (allele != null) {
            return DataResult.success((Object)allele);
        }
        return DataResult.error((String)("Unknown allele: " + id));
    }, allele -> DataResult.success((Object)allele.alleleId()));
    private final Codec<IChromosome<?>> chromosomeCodec = ResourceLocation.f_135803_.flatXmap(id -> {
        IChromosome<?> chromosome = this.getChromosome((ResourceLocation)id);
        if (chromosome != null) {
            return DataResult.success(chromosome);
        }
        return DataResult.error((String)("Unknown chromosome: " + id));
    }, chromosome -> DataResult.success((Object)chromosome.id()));
    private int registrationState = 0;

    private void checkAlleleRegistration() {
        if (this.registrationState == 2) {
            throw new IllegalStateException("Registration of alleles has already finished");
        }
    }

    @Override
    public IBooleanAllele booleanAllele(boolean value, boolean dominant) {
        this.checkAlleleRegistration();
        int index = value ? (dominant ? 3 : 2) : (dominant ? 1 : 0);
        IBooleanAllele allele = this.booleanAlleles[index];
        if (allele == null) {
            this.booleanAlleles[index] = allele = new BooleanAllele(value, dominant);
            this.allelesByName.put(allele.alleleId(), allele);
        }
        return allele;
    }

    @Override
    public IIntegerAllele intAllele(int value, boolean dominant) {
        this.checkAlleleRegistration();
        return (IIntegerAllele)(dominant ? this.dominantIntAlleles : this.intAlleles).computeIfAbsent(value, v -> {
            IntegerAllele allele = new IntegerAllele(v, dominant);
            if (this.allelesByName.put(allele.alleleId(), allele) != null) {
                throw new IllegalStateException("An allele was already registered with ID " + allele.alleleId());
            }
            return allele;
        });
    }

    @Override
    public IFloatAllele floatAllele(float value, boolean dominant) {
        this.checkAlleleRegistration();
        return (IFloatAllele)(dominant ? this.dominantFloatAlleles : this.floatAlleles).computeIfAbsent(value, v -> {
            FloatAllele allele = new FloatAllele(v, dominant);
            if (this.allelesByName.put(allele.alleleId(), allele) != null) {
                throw new IllegalStateException("An allele was already registered with ID " + allele.alleleId());
            }
            return allele;
        });
    }

    @Override
    public <V extends IRegistryAlleleValue> IRegistryAllele<V> registryAllele(ResourceLocation id, IRegistryChromosome<V> chromosome) {
        this.checkAlleleRegistration();
        return (IRegistryAllele)this.allelesByName.computeIfAbsent(id, key -> new RegistryAllele((ResourceLocation)key, chromosome));
    }

    @Override
    public <V> IValueAllele<V> valueAllele(V value, boolean dominant, IAlleleNaming<V> naming) {
        Preconditions.checkNotNull(value, (Object)"Allele value must not be null");
        this.checkAlleleRegistration();
        HashMap<?, IValueAllele<?>> valueToAlleleMap = dominant ? this.dominantValueAlleles : this.valueAlleles;
        IValueAllele<?> valueExisting = valueToAlleleMap.get(value);
        if (valueExisting != null) {
            return valueExisting;
        }
        ResourceLocation name = naming.getName(value, dominant);
        IAllele byName = this.allelesByName.get(name);
        if (byName != null) {
            if (byName instanceof IValueAllele) {
                IValueAllele allele = (IValueAllele)byName;
                if (allele.value() != value) {
                    throw new IllegalStateException("Tried to register two values with the same value allele ID: " + allele.value() + " and " + value + " under ID " + name);
                }
                return allele;
            }
            throw new IllegalStateException("Tried to register a value allele with ID " + name + " but an allele was already registered with type " + byName.getClass());
        }
        ValueAllele<V> allele = new ValueAllele<V>(name, value, dominant);
        valueToAlleleMap.put(value, allele);
        this.allelesByName.put(name, allele);
        return allele;
    }

    @Override
    public Codec<IAllele> alleleCodec() {
        return this.alleleCodec;
    }

    @Override
    public Codec<IChromosome<?>> chromosomeCodec() {
        return this.chromosomeCodec;
    }

    @Override
    @Nullable
    public IAllele getAllele(ResourceLocation id) {
        return this.allelesByName.get(id);
    }

    @Nullable
    private IChromosome<?> getChromosome(ResourceLocation id) {
        return this.chromosomes.get(id);
    }

    private void checkChromosomeRegistration() {
        if (this.registrationState == 1) {
            throw new IllegalStateException("Registration of chromosomes has already finished");
        }
    }

    @Override
    public IFloatChromosome floatChromosome(ResourceLocation id) {
        this.checkChromosomeRegistration();
        return (IFloatChromosome)this.chromosomes.computeIfAbsent(id, FloatChromosome::new);
    }

    @Override
    public IIntegerChromosome intChromosome(ResourceLocation id) {
        this.checkChromosomeRegistration();
        return (IIntegerChromosome)this.chromosomes.computeIfAbsent(id, IntegerChromosome::new);
    }

    @Override
    public IBooleanChromosome booleanChromosome(ResourceLocation id) {
        this.checkChromosomeRegistration();
        return (IBooleanChromosome)this.chromosomes.computeIfAbsent(id, BooleanChromosome::new);
    }

    @Override
    public <V> IValueChromosome<V> valueChromosome(ResourceLocation id, Class<V> valueClass) {
        this.checkChromosomeRegistration();
        return this.registerValueChromosome(id, valueClass, ValueChromosome::new);
    }

    @Override
    public <V extends IRegistryAlleleValue> IRegistryChromosome<V> registryChromosome(ResourceLocation id, Class<V> valueClass) {
        this.checkChromosomeRegistration();
        return this.registerValueChromosome(id, valueClass, RegistryChromosome::new);
    }

    private <V, C extends IValueChromosome<V>> C registerValueChromosome(ResourceLocation id, Class<V> valueClass, BiFunction<ResourceLocation, Class<V>, C> factory) {
        IValueChromosome existing = (IValueChromosome)this.chromosomes.get(id);
        if (existing == null) {
            IValueChromosome chromosome = (IValueChromosome)factory.apply(id, valueClass);
            this.chromosomes.put(id, chromosome);
            return (C)chromosome;
        }
        if (existing.valueClass().equals(valueClass)) {
            return (C)existing;
        }
        throw new IllegalStateException("A chromosome is already registered with ID " + id + " with a different value type: " + existing.valueClass() + " was registered, but tried register again with valueClass: " + valueClass);
    }

    public void setRegistrationState(int state) {
        Preconditions.checkArgument((state == 1 || state == 2 ? 1 : 0) != 0, (Object)"Invalid registry state");
        ++this.registrationState;
        if (this.registrationState != state) {
            throw new IllegalStateException("That registration state has already finished: " + state);
        }
        if (state == 2) {
            this.dominantFloatAlleles.trim();
            this.floatAlleles.trim();
            this.dominantIntAlleles.trim();
            this.intAlleles.trim();
            boolean hasErrors = false;
            for (ISpeciesType<?, ?> type : IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypes()) {
                for (IChromosome chromosome : type.getKaryotype().getChromosomes()) {
                    if (!(chromosome instanceof RegistryChromosome)) continue;
                    RegistryChromosome registry = (RegistryChromosome)chromosome;
                    boolean missingValues = false;
                    for (IRegistryAllele allele : registry.alleles()) {
                        if (allele.value() != null) continue;
                        if (!missingValues) {
                            Forestry.LOGGER.error("Registry chromosome {} is missing values for the following alleles: ", (Object)chromosome.id());
                            hasErrors = true;
                            missingValues = true;
                        }
                        Forestry.LOGGER.error("  > {}", (Object)allele.alleleId());
                    }
                }
            }
            if (hasErrors) {
                throw new IllegalStateException("Missing values for certain IRegistryAllele - check log for details");
            }
        }
    }
}

