/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.analyzer;

import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.core.genetics.analyzer.DatabaseTab;
import forestry.core.gui.GuiConstants;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.LayoutHelper;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class MutationsTab<I extends IIndividual>
extends DatabaseTab<I> {
    public MutationsTab(Supplier<ItemStack> stackSupplier) {
        super("mutations", stackSupplier);
    }

    @Override
    public void createElements(DatabaseElement container, IIndividual individual, ILifeStage stage, ItemStack stack) {
        Collection<IMutation<ISpecies<?>>> mutationsInto;
        ISpecies<?> species = individual.getSpecies();
        ISpeciesType<ISpecies<?>, ?> speciesType = species.getType();
        IMutationManager<ISpecies<?>> mutationContainer = speciesType.getMutations();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        IBreedingTracker breedingTracker = speciesType.getBreedingTracker((LevelAccessor)player.f_19853_, player.m_36316_());
        LayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.horizontal(16, 0, new Insets(0, 1, 0, 0)), 100, 16);
        Collection<IMutation<ISpecies<?>>> mutations = this.getValidMutations(mutationContainer.getMutationsFrom((ISpecies<?>)species.cast()));
        if (!mutations.isEmpty()) {
            container.label((Component)Component.m_237115_((String)"for.gui.database.mutations.further"), Alignment.TOP_CENTER, GuiConstants.UNDERLINED_STYLE.m_131140_(ChatFormatting.WHITE));
            mutations.forEach(mutation -> groupHelper.add(GuiElementFactory.INSTANCE.createMutation(0, 0, 50, 16, (IMutation<?>)mutation, species, breedingTracker)));
            groupHelper.finish(true);
        }
        if ((mutationsInto = this.getValidMutations(mutationContainer.getMutationsInto((ISpecies<?>)species.cast()))).isEmpty()) {
            return;
        }
        container.label((Component)Component.m_237115_((String)"for.gui.database.mutations.resultant"), Alignment.TOP_CENTER, GuiConstants.UNDERLINED_STYLE.m_131140_(ChatFormatting.WHITE));
        mutationsInto.forEach(mutation -> groupHelper.add(GuiElementFactory.INSTANCE.createMutationResultant(0, 0, 50, 16, (IMutation<?>)mutation, breedingTracker)));
        groupHelper.finish(true);
    }

    private <M extends IMutation<?>> Collection<M> getValidMutations(List<M> mutations) {
        ArrayList<IMutation> validMutations = new ArrayList<IMutation>();
        for (IMutation mutation : mutations) {
            if (mutation.isSecret()) continue;
            validMutations.add(mutation);
        }
        return validMutations;
    }
}

