/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.analyzer;

import forestry.api.apiculture.genetics.IBee;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.core.IProduct;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.core.genetics.analyzer.DatabaseTab;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import forestry.core.gui.elements.layouts.LayoutHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class ProductsTab<I extends IIndividual>
extends DatabaseTab<I> {
    public ProductsTab(Supplier<ItemStack> stackSupplier) {
        super("products", stackSupplier);
    }

    @Override
    public void createElements(DatabaseElement container, I individual, ILifeStage stage, ItemStack stack) {
        List<IProduct> specialties;
        LayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.horizontal(18, 2, FlexLayout.LEFT_MARGIN), 90, 0);
        List<IProduct> products = this.getProducts((IIndividual)individual);
        if (!products.isEmpty()) {
            container.translated("for.gui.beealyzer.produce", new Object[0]).setStyle(Style.f_131099_.m_131140_(ChatFormatting.WHITE)).setAlign(Alignment.TOP_CENTER);
            products.forEach(product -> groupHelper.add(new ItemElement(0, 0, product.createStack())));
            groupHelper.finish();
        }
        if ((specialties = this.getSpecialties((IIndividual)individual)).isEmpty()) {
            return;
        }
        container.translated("for.gui.beealyzer.specialty", new Object[0]).setAlign(Alignment.TOP_CENTER);
        specialties.forEach(specialty -> groupHelper.add(new ItemElement(0, 0, specialty.createStack())));
        groupHelper.finish();
    }

    private List<IProduct> getSpecialties(IIndividual individual) {
        if (individual instanceof IBee) {
            IBee bee = (IBee)individual;
            return bee.getSpecies().getSpecialties();
        }
        if (individual instanceof ITree) {
            ITree tree = (ITree)individual;
            return tree.getSpecialties();
        }
        return List.of();
    }

    private List<IProduct> getProducts(IIndividual individual) {
        if (individual instanceof IBee) {
            IBee bee = (IBee)individual;
            return bee.getSpecies().getProducts();
        }
        if (individual instanceof ITree) {
            ITree tree = (ITree)individual;
            return tree.getProducts();
        }
        return List.of();
    }
}

